/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide.idea;

import java.util.Objects;
import net.fabricmc.loom.util.gradle.SourceSetReference;
import org.gradle.api.Project;

public class IdeaUtils {
    public static boolean isIdeaSync() {
        return Boolean.parseBoolean(System.getProperty("idea.sync.active", "false"));
    }

    public static String getIdeaVersion() {
        return Objects.requireNonNull(System.getProperty("idea.version"), "Could not get idea version");
    }

    public static boolean supportsCustomizableClasspath() {
        String[] split = IdeaUtils.getIdeaVersion().split("\\.");
        int major = Integer.parseInt(split[0]);
        int minor = Integer.parseInt(split[1]);
        return major > 2021 || major == 2021 && minor >= 3;
    }

    public static String getIdeaModuleName(SourceSetReference reference) {
        Project project = reference.project();
        String module = project.getName() + "." + reference.sourceSet().getName();
        while ((project = project.getParent()) != null) {
            module = project.getName() + "." + module;
        }
        return module;
    }
}

