/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ifaceinject;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.api.InterfaceInjectionExtensionAPI;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ModUtils;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrRemapper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.SourceSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;

public class InterfaceInjectionProcessor
implements JarProcessor,
GenerateSourcesTask.MappingsProcessor {
    private static final String HASH_FILENAME = "injected_interfaces.sha256";
    private final Map<String, List<InjectedInterface>> injectedInterfaces;
    private final Project project;
    private final LoomGradleExtension extension;
    private final InterfaceInjectionExtensionAPI interfaceInjectionExtension;
    private final byte[] inputHash;
    private Map<String, List<InjectedInterface>> remappedInjectedInterfaces;

    public InterfaceInjectionProcessor(Project project) {
        this.project = project;
        this.extension = LoomGradleExtension.get(project);
        this.interfaceInjectionExtension = this.extension.getInterfaceInjection();
        this.injectedInterfaces = this.getInjectedInterfaces().stream().collect(Collectors.groupingBy(InjectedInterface::className));
        this.inputHash = this.hashInjectedInterfaces();
    }

    public boolean isEmpty() {
        return this.injectedInterfaces.isEmpty();
    }

    @Override
    public String getId() {
        Preconditions.checkArgument((!this.isEmpty() ? 1 : 0) != 0);
        return "loom:interface_injection:" + Checksum.toHex(this.inputHash);
    }

    @Override
    public void setup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(File jarFile) {
        if (this.remappedInjectedInterfaces == null) {
            TinyRemapper tinyRemapper = this.createTinyRemapper();
            TrRemapper remapper = tinyRemapper.getEnvironment().getRemapper();
            try {
                this.remappedInjectedInterfaces = new HashMap<String, List<InjectedInterface>>(this.injectedInterfaces.size());
                for (Map.Entry<String, List<InjectedInterface>> entry : this.injectedInterfaces.entrySet()) {
                    String namedClassName = remapper.map(entry.getKey());
                    this.remappedInjectedInterfaces.put(namedClassName, entry.getValue().stream().map(arg_0 -> InterfaceInjectionProcessor.lambda$process$0(namedClassName, (Remapper)remapper, arg_0)).toList());
                }
            }
            finally {
                tinyRemapper.finish();
            }
        }
        try {
            ZipUtils.transform(jarFile.toPath(), this.getTransformers());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to apply interface injections to " + jarFile, e);
        }
    }

    private List<Pair<String, ZipUtils.UnsafeUnaryOperator<byte[]>>> getTransformers() {
        return this.remappedInjectedInterfaces.keySet().stream().map(string -> new Pair<CallSite, ZipUtils.UnsafeUnaryOperator<byte[]>>((CallSite)((Object)(string.replaceAll("\\.", "/") + ".class")), this.getTransformer((String)string))).collect(Collectors.toList());
    }

    private ZipUtils.UnsafeUnaryOperator<byte[]> getTransformer(String className) {
        return input -> {
            ClassReader reader = new ClassReader(input);
            ClassWriter writer = new ClassWriter(0);
            List<InjectedInterface> ifaces = this.remappedInjectedInterfaces.get(className);
            InjectingClassVisitor classVisitor = new InjectingClassVisitor(589824, writer, ifaces);
            this.project.getLogger().info("Injecting interfaces into " + className + ": " + ifaces.stream().map(i -> i.ifaceName() + " [" + i.modId() + "]").collect(Collectors.joining(", ")));
            reader.accept((ClassVisitor)classVisitor, 0);
            return writer.toByteArray();
        };
    }

    private List<InjectedInterface> getInjectedInterfaces() {
        ArrayList<InjectedInterface> result = new ArrayList<InjectedInterface>();
        if (((Boolean)this.interfaceInjectionExtension.getEnableDependencyInterfaceInjection().get()).booleanValue()) {
            result.addAll(this.getDependencyInjectedInterfaces());
        }
        for (SourceSet sourceSet : (List)this.interfaceInjectionExtension.getInterfaceInjectionSourceSets().get()) {
            result.addAll(this.getSourceInjectedInterface(sourceSet));
        }
        return result;
    }

    private List<InjectedInterface> getDependencyInjectedInterfaces() {
        Function<RemapConfigurationSettings, Stream> resolve = settings -> ((Configuration)settings.getSourceConfiguration().get()).resolve().stream().map(File::toPath);
        List runtimeEntries = this.extension.getRuntimeRemapConfigurations().stream().flatMap(resolve).toList();
        return this.extension.getCompileRemapConfigurations().stream().flatMap(resolve).filter(runtimeEntries::contains).flatMap(path -> InjectedInterface.fromModJar(path).stream()).toList();
    }

    private List<InjectedInterface> getSourceInjectedInterface(SourceSet sourceSet) {
        String jsonString;
        File fabricModJson;
        try {
            fabricModJson = sourceSet.getResources().matching(patternFilterable -> patternFilterable.include(new String[]{"fabric.mod.json"})).getSingleFile();
        }
        catch (IllegalStateException e) {
            return Collections.emptyList();
        }
        try {
            jsonString = Files.readString(fabricModJson.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read fabric.mod.json", e);
        }
        JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(jsonString, JsonObject.class);
        return InjectedInterface.fromJson(jsonObject);
    }

    @Override
    public boolean transform(MemoryMappingTree mappings) {
        if (this.injectedInterfaces.isEmpty()) {
            return false;
        }
        if (!MappingsNamespace.INTERMEDIARY.toString().equals(mappings.getSrcNamespace())) {
            throw new IllegalStateException("Mapping tree must have intermediary src mappings not " + mappings.getSrcNamespace());
        }
        for (Map.Entry<String, List<InjectedInterface>> entry : this.injectedInterfaces.entrySet()) {
            String className = entry.getKey();
            List<InjectedInterface> injectedInterfaces = entry.getValue();
            MemoryMappingTree.ClassEntry classMapping = mappings.getClass(className);
            if (classMapping == null) {
                String modIds = injectedInterfaces.stream().map(InjectedInterface::modId).distinct().collect(Collectors.joining(","));
                this.project.getLogger().warn("Failed to find class ({}) to add injected interfaces from mod(s) ({})", (Object)className, (Object)modIds);
                continue;
            }
            classMapping.setComment(InterfaceInjectionProcessor.appendComment(classMapping.getComment(), injectedInterfaces));
        }
        return true;
    }

    private static String appendComment(String comment, List<InjectedInterface> injectedInterfaces) {
        for (InjectedInterface injectedInterface : injectedInterfaces) {
            String iiComment = "Interface {@link %s} injected by mod %s".formatted(injectedInterface.ifaceName.substring(injectedInterface.ifaceName.lastIndexOf("/") + 1), injectedInterface.modId);
            if (comment != null && ((String)comment).contains(iiComment)) continue;
            if (comment == null) {
                comment = iiComment;
                continue;
            }
            comment = (String)comment + "\n" + iiComment;
        }
        return comment;
    }

    private TinyRemapper createTinyRemapper() {
        try {
            TinyRemapper tinyRemapper = TinyRemapperHelper.getTinyRemapper(this.project, "intermediary", "named");
            tinyRemapper.readClassPath(TinyRemapperHelper.getMinecraftDependencies(this.project));
            for (Path minecraftJar : this.extension.getMinecraftJars(MappingsNamespace.INTERMEDIARY)) {
                tinyRemapper.readClassPath(new Path[]{minecraftJar});
            }
            return tinyRemapper;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create tiny remapper for intermediary->named", e);
        }
    }

    private byte[] hashInjectedInterfaces() {
        Hasher hasher = Hashing.sha256().newHasher();
        for (Map.Entry<String, List<InjectedInterface>> entry : this.injectedInterfaces.entrySet()) {
            hasher.putString((CharSequence)"class:", StandardCharsets.UTF_8);
            hasher.putString((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
            for (InjectedInterface ifaceName : entry.getValue()) {
                hasher.putString((CharSequence)"iface:", StandardCharsets.UTF_8);
                hasher.putString((CharSequence)ifaceName.ifaceName(), StandardCharsets.UTF_8);
            }
        }
        return hasher.hash().asBytes();
    }

    private static /* synthetic */ InjectedInterface lambda$process$0(String namedClassName, Remapper remapper, InjectedInterface injectedInterface) {
        return new InjectedInterface(injectedInterface.modId(), namedClassName, remapper.map(injectedInterface.ifaceName()));
    }

    private record InjectedInterface(String modId, String className, String ifaceName) {
        public static List<InjectedInterface> fromModJar(Path modJarPath) {
            JsonObject jsonObject = ModUtils.getFabricModJson(modJarPath);
            if (jsonObject == null) {
                return Collections.emptyList();
            }
            return InjectedInterface.fromJson(jsonObject);
        }

        public static List<InjectedInterface> fromJson(JsonObject jsonObject) {
            String modId = jsonObject.get("id").getAsString();
            if (!jsonObject.has("custom")) {
                return Collections.emptyList();
            }
            JsonObject custom = jsonObject.getAsJsonObject("custom");
            if (!custom.has("loom:injected_interfaces")) {
                return Collections.emptyList();
            }
            JsonObject addedIfaces = custom.getAsJsonObject("loom:injected_interfaces");
            ArrayList<InjectedInterface> result = new ArrayList<InjectedInterface>();
            for (String className : addedIfaces.keySet()) {
                JsonArray ifaceNames = addedIfaces.getAsJsonArray(className);
                for (JsonElement ifaceName : ifaceNames) {
                    result.add(new InjectedInterface(modId, className, ifaceName.getAsString()));
                }
            }
            return result;
        }
    }

    private static class InjectingClassVisitor
    extends ClassVisitor {
        private final List<InjectedInterface> injectedInterfaces;

        InjectingClassVisitor(int asmVersion, ClassWriter writer, List<InjectedInterface> injectedInterfaces) {
            super(asmVersion, (ClassVisitor)writer);
            this.injectedInterfaces = injectedInterfaces;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            LinkedHashSet<String> modifiedInterfaces = new LinkedHashSet<String>(interfaces.length + this.injectedInterfaces.size());
            Collections.addAll(modifiedInterfaces, interfaces);
            for (InjectedInterface injectedInterface : this.injectedInterfaces) {
                modifiedInterfaces.add(injectedInterface.ifaceName());
            }
            if (signature != null) {
                StringBuilder resultingSignature = new StringBuilder(signature);
                for (InjectedInterface injectedInterface : this.injectedInterfaces) {
                    String superinterfaceSignature = "L" + injectedInterface.ifaceName() + ";";
                    if (resultingSignature.indexOf(superinterfaceSignature) != -1) continue;
                    resultingSignature.append(superinterfaceSignature);
                }
                signature = resultingSignature.toString();
            }
            super.visit(version, access, name, signature, superName, modifiedInterfaces.toArray(new String[0]));
        }
    }
}

