/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerRemapper;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.accesswidener.AccessWidenerWriter;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.ZipUtils;
import org.objectweb.asm.commons.Remapper;

public class AccessWidenerUtils {
    public static byte[] remapAccessWidener(byte[] input, Remapper remapper) {
        int version = AccessWidenerReader.readVersion((byte[])input);
        AccessWidenerWriter writer = new AccessWidenerWriter(version);
        AccessWidenerRemapper awRemapper = new AccessWidenerRemapper((AccessWidenerVisitor)writer, remapper, MappingsNamespace.INTERMEDIARY.toString(), MappingsNamespace.NAMED.toString());
        AccessWidenerReader reader = new AccessWidenerReader((AccessWidenerVisitor)awRemapper);
        reader.read(input);
        return writer.write();
    }

    public static AccessWidenerData readAccessWidenerData(Path inputJar) throws IOException {
        byte[] modJsonBytes = ZipUtils.unpack(inputJar, "fabric.mod.json");
        JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(new String(modJsonBytes, StandardCharsets.UTF_8), JsonObject.class);
        if (!jsonObject.has("accessWidener")) {
            return null;
        }
        String accessWidenerPath = jsonObject.get("accessWidener").getAsString();
        byte[] accessWidener = ZipUtils.unpack(inputJar, accessWidenerPath);
        AccessWidenerReader.Header header = AccessWidenerReader.readHeader((byte[])accessWidener);
        return new AccessWidenerData(accessWidenerPath, header, accessWidener);
    }

    public record AccessWidenerData(String path, AccessWidenerReader.Header header, byte[] content) {
    }
}

