/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.configuration.mods.ModProcessor;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import net.fabricmc.loom.configuration.mods.dependency.ModDependencyFactory;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ModUtils;
import net.fabricmc.loom.util.OperatingSystem;
import net.fabricmc.loom.util.SourceRemapper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.jetbrains.annotations.Nullable;

public class ModConfigurationRemapper {
    public static final String MISSING_GROUP = "unspecified";

    public static void supplyModConfigurations(Project project, String mappingsSuffix, LoomGradleExtension extension, SourceRemapper sourceRemapper) {
        DependencyHandler dependencies = project.getDependencies();
        for (RemapConfigurationSettings entry : extension.getRemapConfigurations()) {
            entry.getRemappedConfiguration().configure(remappedConfig -> {
                Configuration sourceConfig = (Configuration)entry.getSourceConfiguration().get();
                Configuration targetConfig = (Configuration)entry.getTargetConfiguration().get();
                boolean hasClientTarget = entry.getClientSourceConfigurationName().isPresent();
                Configuration clientRemappedConfig = null;
                if (hasClientTarget) {
                    clientRemappedConfig = (Configuration)entry.getClientRemappedConfiguration().get();
                }
                ArrayList<ModDependency> modDependencies = new ArrayList<ModDependency>();
                for (ArtifactRef artifact : ModConfigurationRemapper.resolveArtifacts(project, sourceConfig)) {
                    if (!ModUtils.isMod(artifact.path())) {
                        artifact.applyToConfiguration(project, targetConfig);
                        continue;
                    }
                    ModDependency modDependency = ModDependencyFactory.create(artifact, remappedConfig, clientRemappedConfig, mappingsSuffix, project);
                    ModConfigurationRemapper.scheduleSourcesRemapping(project, sourceRemapper, modDependency);
                    modDependencies.add(modDependency);
                }
                if (modDependencies.isEmpty()) {
                    return;
                }
                boolean refreshDeps = LoomGradleExtension.get(project).refreshDeps();
                List<ModDependency> toRemap = modDependencies.stream().filter(dependency -> refreshDeps || dependency.isCacheInvalid(project, null)).toList();
                if (!toRemap.isEmpty()) {
                    try {
                        new ModProcessor(project, sourceConfig).processMods(toRemap);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to remap mods", e);
                    }
                }
                for (ModDependency info : modDependencies) {
                    info.applyToProject(project);
                    ModConfigurationRemapper.createConstraints(info.getInputArtifact(), targetConfig, sourceConfig, dependencies);
                    if (clientRemappedConfig == null) continue;
                    ModConfigurationRemapper.createConstraints(info.getInputArtifact(), (Configuration)entry.getClientTargetConfiguration().get(), sourceConfig, dependencies);
                }
                if (((String)entry.getTargetConfigurationName().get()).equals("api")) {
                    project.getConfigurations().getByName("namedElements").extendsFrom(new Configuration[]{remappedConfig});
                }
            });
        }
    }

    private static void createConstraints(ArtifactRef artifact, Configuration targetConfig, Configuration sourceConfig, DependencyHandler dependencies) {
    }

    private static List<ArtifactRef> resolveArtifacts(Project project, Configuration configuration) {
        ArrayList<ArtifactRef> artifacts = new ArrayList<ArtifactRef>();
        for (ResolvedArtifact artifact : configuration.getResolvedConfiguration().getResolvedArtifacts()) {
            Path sources = ModConfigurationRemapper.findSources(project, artifact);
            artifacts.add(new ArtifactRef.ResolvedArtifactRef(artifact, sources));
        }
        for (FileCollectionDependency dependency : configuration.getAllDependencies().withType(FileCollectionDependency.class)) {
            String group = ModConfigurationRemapper.replaceIfNullOrEmpty(dependency.getGroup(), () -> MISSING_GROUP);
            FileCollection files = dependency.getFiles();
            for (File artifact : files) {
                String name = ModConfigurationRemapper.getNameWithoutExtension(artifact.toPath());
                String version = ModConfigurationRemapper.replaceIfNullOrEmpty(dependency.getVersion(), () -> Checksum.truncatedSha256(artifact));
                artifacts.add(new ArtifactRef.FileArtifactRef(artifact.toPath(), group, name, version));
            }
        }
        return artifacts;
    }

    private static String getNameWithoutExtension(Path file) {
        String fileName = file.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    @Nullable
    public static Path findSources(Project project, ResolvedArtifact artifact) {
        DependencyHandler dependencies = project.getDependencies();
        ArtifactResolutionQuery query = dependencies.createArtifactResolutionQuery().forComponents(new ComponentIdentifier[]{artifact.getId().getComponentIdentifier()}).withArtifacts(JvmLibrary.class, new Class[]{SourcesArtifact.class});
        for (ComponentArtifactsResult result : query.execute().getResolvedComponents()) {
            for (ArtifactResult srcArtifact : result.getArtifacts(SourcesArtifact.class)) {
                if (!(srcArtifact instanceof ResolvedArtifactResult)) continue;
                return ((ResolvedArtifactResult)srcArtifact).getFile().toPath();
            }
        }
        return null;
    }

    private static void scheduleSourcesRemapping(Project project, SourceRemapper sourceRemapper, ModDependency dependency) {
        if (OperatingSystem.isCIBuild()) {
            return;
        }
        Path sourcesInput = dependency.getInputArtifact().sources();
        if (sourcesInput == null || Files.notExists(sourcesInput, new LinkOption[0])) {
            return;
        }
        if (dependency.isCacheInvalid(project, "sources")) {
            Path output = dependency.getWorkingFile("sources");
            sourceRemapper.scheduleRemapSources(sourcesInput.toFile(), output.toFile(), false, true, () -> {
                try {
                    dependency.copyToCache(project, output, "sources");
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to apply sources to local cache for: " + dependency, e);
                }
            });
        }
    }

    public static String replaceIfNullOrEmpty(@Nullable String s, Supplier<String> fallback) {
        return s == null || s.isEmpty() ? fallback.get() : s;
    }

    private static /* synthetic */ void lambda$createConstraints$2(Configuration targetConfig, Configuration sourceConfig, DependencyConstraint constraint) {
        constraint.because("configuration (%s) already contains the remapped module from configuration (%s)".formatted(targetConfig.getName(), sourceConfig.getName()));
        constraint.version(MutableVersionConstraint::rejectAll);
    }
}

