/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.mods.dependency.ModDependency;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;

public final class LocalMavenHelper {
    private final String group;
    private final String name;
    private final String version;
    @Nullable
    private final String baseClassifier;
    private final Project project;

    LocalMavenHelper(String group, String name, String version, @Nullable String classifier, Project project) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.baseClassifier = classifier;
        this.project = project;
    }

    public Path copyToMaven(Path artifact, @Nullable String classifier) throws IOException {
        if (!artifact.getFileName().toString().endsWith(".jar")) {
            throw new UnsupportedOperationException();
        }
        Files.createDirectories(this.getDirectory(), new FileAttribute[0]);
        this.savePom();
        return Files.copy(artifact, this.getOutputFile(classifier), StandardCopyOption.REPLACE_EXISTING);
    }

    public boolean exists(String classifier) {
        return Files.exists(this.getOutputFile(classifier), new LinkOption[0]) && Files.exists(this.getPomPath(), new LinkOption[0]);
    }

    public String getNotation() {
        if (this.baseClassifier != null) {
            return String.format("%s:%s:%s:%s", this.group, this.name, this.version, this.baseClassifier);
        }
        return String.format("%s:%s:%s", this.group, this.name, this.version);
    }

    private void savePom() {
        try {
            String pomTemplate;
            try (InputStream input = ModDependency.class.getClassLoader().getResourceAsStream("mod_compile_template.pom");){
                pomTemplate = new String(input.readAllBytes(), StandardCharsets.UTF_8);
            }
            pomTemplate = pomTemplate.replace("%GROUP%", this.group).replace("%NAME%", this.name).replace("%VERSION%", this.version);
            Files.writeString(this.getPomPath(), (CharSequence)pomTemplate, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write mod pom", e);
        }
    }

    private Path getRoot() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        return extension.getFiles().getRemappedModCache().toPath();
    }

    private Path getDirectory() {
        return this.getRoot().resolve("%s/%s/%s".formatted(this.group.replace(".", "/"), this.name, this.version));
    }

    private Path getPomPath() {
        return this.getDirectory().resolve("%s-%s.pom".formatted(this.name, this.version));
    }

    public Path getOutputFile(@Nullable String classifier) {
        if (classifier == null) {
            classifier = this.baseClassifier;
        }
        String fileName = classifier == null ? String.format("%s-%s.jar", this.name, this.version) : String.format("%s-%s-%s.jar", this.name, this.version, classifier);
        return this.getDirectory().resolve(fileName);
    }
}

