/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.CharSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import net.fabricmc.loom.util.ZipUtils;

public class JarProcessorManager {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String JAR_PROCESSOR_HASH_ATTRIBUTE = "Loom-Jar-Processor-Hash";
    private final List<JarProcessor> jarProcessors;

    public JarProcessorManager(List<JarProcessor> jarProcessors) {
        this.jarProcessors = jarProcessors;
    }

    public void setupProcessors() {
        this.jarProcessors.forEach(JarProcessor::setup);
    }

    public boolean active() {
        return !this.jarProcessors.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInvalid(File file) {
        if (!file.exists()) {
            return true;
        }
        String jarProcessorHash = this.getJarProcessorHash();
        try (JarFile jar = new JarFile(file);){
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                boolean bl = false;
                return bl;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (jarProcessorHash.equals(attributes.getValue(JAR_PROCESSOR_HASH_ATTRIBUTE))) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not check jar manifest of " + file, e);
        }
    }

    private String getJarProcessorHash() {
        String jarProcessorIds = this.jarProcessors.stream().map(JarProcessor::getId).sorted().collect(Collectors.joining(";"));
        try {
            return CharSource.wrap((CharSequence)jarProcessorIds).asByteSource(StandardCharsets.UTF_8).hash(Hashing.sha256()).toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not hash jar processor IDs", e);
        }
    }

    public void process(File file) {
        for (JarProcessor jarProcessor : this.jarProcessors) {
            jarProcessor.process(file);
        }
        try {
            int count = ZipUtils.transform(file.toPath(), Map.of(MANIFEST_PATH, bytes -> {
                Manifest manifest = new Manifest(new ByteArrayInputStream((byte[])bytes));
                manifest.getMainAttributes().putValue(JAR_PROCESSOR_HASH_ATTRIBUTE, this.getJarProcessorHash());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                manifest.write(out);
                return out.toByteArray();
            }));
            Preconditions.checkState((count > 0 ? 1 : 0) != 0, (Object)("Did not add data to jar manifest in " + file));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not add data to jar manifest in " + file, e);
        }
    }

    public <T extends JarProcessor> T getByType(Class<T> tClass) {
        return (T)((JarProcessor)this.jarProcessors.stream().filter(jarProcessor -> jarProcessor.getClass().equals(tClass)).findFirst().orElse(null));
    }
}

