/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.processors.JarProcessor;
import net.fabricmc.loom.task.GenerateSourcesTask;
import net.fabricmc.loom.util.ModUtils;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModJavadocProcessor
implements JarProcessor,
GenerateSourcesTask.MappingsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModJavadocProcessor.class);
    private final List<ModJavadoc> javadocs;

    private ModJavadocProcessor(List<ModJavadoc> javadocs) {
        this.javadocs = javadocs;
    }

    @Nullable
    public static ModJavadocProcessor create(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ArrayList<ModJavadoc> javadocs = new ArrayList<ModJavadoc>();
        for (RemapConfigurationSettings entry : extension.getRemapConfigurations()) {
            Set artifacts = ((Configuration)entry.getSourceConfiguration().get()).resolve();
            for (File artifact : artifacts) {
                ModJavadoc modJavadoc;
                if (!ModUtils.isMod(artifact.toPath())) continue;
                try {
                    modJavadoc = ModJavadoc.fromModJar(artifact.toPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read mod jar (%s)".formatted(artifact), e);
                }
                if (modJavadoc == null) continue;
                javadocs.add(modJavadoc);
            }
        }
        if (javadocs.isEmpty()) {
            return null;
        }
        return new ModJavadocProcessor(javadocs);
    }

    @Override
    public boolean transform(MemoryMappingTree mappings) {
        for (ModJavadoc javadoc : this.javadocs) {
            javadoc.apply(mappings);
        }
        return true;
    }

    @Override
    public String getId() {
        return "loom:interface_injection:" + this.javadocs.hashCode();
    }

    @Override
    public void setup() {
    }

    @Override
    public void process(File file) {
    }

    public record ModJavadoc(String modId, MemoryMappingTree mappingTree) {
        @Nullable
        public static ModJavadoc fromModJar(Path path) throws IOException {
            JsonObject jsonObject = ModUtils.getFabricModJson(path);
            if (jsonObject == null || !jsonObject.has("custom")) {
                return null;
            }
            String modId = jsonObject.get("id").getAsString();
            JsonObject custom = jsonObject.getAsJsonObject("custom");
            if (!custom.has("loom:provided_javadoc")) {
                return null;
            }
            String javaDocPath = custom.getAsJsonPrimitive("loom:provided_javadoc").getAsString();
            byte[] data = ZipUtils.unpack(path, javaDocPath);
            MemoryMappingTree mappings = new MemoryMappingTree();
            try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(data));){
                MappingReader.read((Reader)reader, (MappingVisitor)mappings);
            }
            if (!mappings.getSrcNamespace().equals(MappingsNamespace.INTERMEDIARY.toString())) {
                throw new IllegalStateException("Javadoc provided by mod (%s) must be have an intermediary source namespace".formatted(modId));
            }
            if (!mappings.getDstNamespaces().isEmpty()) {
                throw new IllegalStateException("Javadoc provided by mod (%s) must not contain any dst names".formatted(modId));
            }
            return new ModJavadoc(modId, mappings);
        }

        public void apply(MemoryMappingTree target) {
            if (!this.mappingTree.getSrcNamespace().equals(target.getSrcNamespace())) {
                throw new IllegalStateException("Cannot apply mappings to differing namespaces. source: %s target: %s".formatted(this.mappingTree.getSrcNamespace(), target.getSrcNamespace()));
            }
            for (MappingTree.ClassMapping sourceClass : this.mappingTree.getClasses()) {
                MemoryMappingTree.ClassEntry targetClass = target.getClass(sourceClass.getSrcName());
                if (targetClass == null) {
                    LOGGER.warn("Could not find provided javadoc target class {} from mod {}", (Object)sourceClass.getSrcName(), (Object)this.modId);
                    continue;
                }
                this.applyComment((MappingTree.ElementMapping)sourceClass, (MappingTree.ElementMapping)targetClass);
                for (MappingTree.FieldMapping sourceField : sourceClass.getFields()) {
                    MappingTree.FieldMapping targetField = targetClass.getField(sourceField.getSrcName(), sourceField.getSrcDesc());
                    if (targetField == null) {
                        LOGGER.warn("Could not find provided javadoc target field {}{} from mod {}", new Object[]{sourceField.getSrcName(), sourceField.getSrcDesc(), this.modId});
                        continue;
                    }
                    this.applyComment(sourceField, targetField);
                }
                for (MappingTree.MethodMapping sourceMethod : sourceClass.getMethods()) {
                    MappingTree.MethodMapping targetMethod = targetClass.getMethod(sourceMethod.getSrcName(), sourceMethod.getSrcDesc());
                    if (targetMethod == null) {
                        LOGGER.warn("Could not find provided javadoc target method {}{} from mod {}", new Object[]{sourceMethod.getSrcName(), sourceMethod.getSrcDesc(), this.modId});
                        continue;
                    }
                    this.applyComment(sourceMethod, targetMethod);
                }
            }
        }

        private <T extends MappingTree.ElementMapping> void applyComment(T source, T target) {
            String sourceComment = source.getComment();
            if (sourceComment == null) {
                LOGGER.warn("Mod {} provided javadoc has mapping for {}, without comment", (Object)this.modId, source);
                return;
            }
            Object targetComment = target.getComment();
            targetComment = targetComment == null ? "" : (String)targetComment + "\n";
            targetComment = (String)targetComment + sourceComment;
            target.setComment((String)targetComment);
        }
    }
}

