/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.tiny;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.format.MappingFormat;

public record TinyJarInfo(boolean v2, Optional<String> minecraftVersionId) {
    public static TinyJarInfo get(Path jar) {
        try {
            return new TinyJarInfo(TinyJarInfo.doesJarContainV2Mappings(jar), Optional.empty());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read tiny jar info", e);
        }
    }

    private static boolean doesJarContainV2Mappings(Path path) throws IOException {
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(path);){
            boolean bl;
            block12: {
                BufferedReader reader = Files.newBufferedReader(delegate.fs().getPath("mappings", "mappings.tiny"));
                try {
                    boolean bl2 = bl = MappingReader.detectFormat((Reader)reader) == MappingFormat.TINY_2;
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return bl;
        }
    }
}

