/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.util.List;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.Architecture;
import net.fabricmc.loom.util.OperatingSystem;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.jetbrains.annotations.Nullable;

public class LWJGLVersionOverride {
    public static final String LWJGL_VERSION = "3.3.1";
    @Nullable
    public static final String NATIVE_CLASSIFIER = LWJGLVersionOverride.getNativesClassifier();
    public static final List<String> DEPENDENCIES = List.of("org.lwjgl:lwjgl:3.3.1", "org.lwjgl:lwjgl-glfw:3.3.1", "org.lwjgl:lwjgl-jemalloc:3.3.1", "org.lwjgl:lwjgl-openal:3.3.1", "org.lwjgl:lwjgl-opengl:3.3.1", "org.lwjgl:lwjgl-stb:3.3.1", "org.lwjgl:lwjgl-tinyfd:3.3.1");
    public static final List<String> NATIVES = DEPENDENCIES.stream().map(s -> s + ":" + NATIVE_CLASSIFIER).toList();
    public static final List<String> MACOS_DEPENDENCIES = List.of("ca.weblite:java-objc-bridge:1.1");
    public static final List<String> MACOS_NATIVES = MACOS_DEPENDENCIES;

    public static boolean overrideByDefault(MinecraftVersionMeta versionMeta) {
        if (NATIVE_CLASSIFIER == null || !Architecture.CURRENT.isArm()) {
            return false;
        }
        boolean supportedLwjglVersion = versionMeta.libraries().stream().anyMatch(library -> library.name().startsWith("org.lwjgl:lwjgl:3"));
        boolean hasExistingNatives = versionMeta.libraries().stream().filter(library -> library.name().startsWith("org.lwjgl:lwjgl")).anyMatch(MinecraftVersionMeta.Library::hasNativesForOS);
        return supportedLwjglVersion && !hasExistingNatives;
    }

    public static boolean forceOverride(Project project) {
        return project.getProperties().get("fabric.loom.override-lwjgl") != null;
    }

    public static void applyOverrides(Project project, boolean isMacOS) {
        DEPENDENCIES.forEach(s -> project.getDependencies().add("minecraftLibraries", s));
        NATIVES.forEach(s -> project.getDependencies().add("minecraftNatives", s));
        if (isMacOS) {
            MACOS_DEPENDENCIES.forEach(s -> project.getDependencies().add("minecraftLibraries", s));
            MACOS_NATIVES.forEach(s -> project.getDependencies().add("minecraftNatives", s));
        }
        ExternalModuleDependency dependency = (ExternalModuleDependency)project.getDependencies().create((Object)"net.fabricmc:fabric-loom-native-support:1.0.1");
        dependency.setTransitive(false);
        project.getDependencies().add("modLocalRuntime", (Object)dependency);
    }

    @Nullable
    private static String getNativesClassifier() {
        return switch (OperatingSystem.CURRENT_OS) {
            case "windows" -> LWJGLVersionOverride.getWindowsClassifier();
            case "osx" -> LWJGLVersionOverride.getMacOSClassifier();
            case "linux" -> LWJGLVersionOverride.getLinuxClassifier();
            default -> null;
        };
    }

    private static String getWindowsClassifier() {
        if (Architecture.CURRENT.is64Bit()) {
            if (Architecture.CURRENT.isArm()) {
                return "natives-windows-arm64";
            }
            return "natives-windows";
        }
        return "natives-windows-x86";
    }

    private static String getMacOSClassifier() {
        if (Architecture.CURRENT.isArm()) {
            return "natives-macos-arm64";
        }
        return "natives-macos";
    }

    private static String getLinuxClassifier() {
        if (Architecture.CURRENT.isArm()) {
            return Architecture.CURRENT.is64Bit() ? "natives-linux-arm64" : "natives-linux-arm32";
        }
        return "natives-linux";
    }
}

