/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.stitch.merge.JarMerger;
import org.gradle.api.Project;

public final class MergedMinecraftProvider
extends MinecraftProvider {
    private Path minecraftMergedJar;

    public MergedMinecraftProvider(Project project) {
        super(project);
    }

    @Override
    protected void initFiles() {
        super.initFiles();
        this.minecraftMergedJar = this.path("minecraft-merged.jar");
    }

    @Override
    public List<Path> getMinecraftJars() {
        return List.of(this.minecraftMergedJar);
    }

    @Override
    public void provide() throws Exception {
        super.provide();
        if (!this.getVersionInfo().isVersionOrNewer("2012-07-25T22:00:00+00:00")) {
            throw new UnsupportedOperationException("Minecraft versions 1.2.5 and older cannot be merged. Please use `loom { server/clientOnlyMinecraftJar() }`");
        }
        if (!Files.exists(this.minecraftMergedJar, new LinkOption[0]) || this.getExtension().refreshDeps()) {
            try {
                this.mergeJars();
            }
            catch (Throwable e) {
                Files.deleteIfExists(this.getMinecraftClientJar().toPath());
                Files.deleteIfExists(this.getMinecraftServerJar().toPath());
                Files.deleteIfExists(this.minecraftMergedJar);
                this.getProject().getLogger().error("Could not merge JARs! Deleting source JARs - please re-run the command and move on.", e);
                throw e;
            }
        }
    }

    private void mergeJars() throws IOException {
        this.getLogger().info(":merging jars");
        File jarToMerge = this.getMinecraftServerJar();
        if (this.getServerBundleMetadata() != null) {
            this.extractBundledServerJar();
            jarToMerge = this.getMinecraftExtractedServerJar();
        }
        Objects.requireNonNull(jarToMerge, "Cannot merge null input jar?");
        try (JarMerger jarMerger = new JarMerger(this.getMinecraftClientJar(), jarToMerge, this.minecraftMergedJar.toFile());){
            jarMerger.enableSyntheticParamsOffset();
            jarMerger.merge();
        }
    }

    public Path getMergedJar() {
        return this.minecraftMergedJar;
    }
}

