/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomRepositoryPlugin;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.LWJGLVersionOverride;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.Architecture;
import net.fabricmc.loom.util.OperatingSystem;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;

public class MinecraftLibraryProvider {
    private static final Pattern NATIVES_PATTERN = Pattern.compile("^(?<group>.*)/(.*?)/(?<version>.*)/((?<name>.*?)-(\\k<version>)-)(?<classifier>.*).jar$");
    private static final boolean IS_MACOS = OperatingSystem.CURRENT_OS.equals("osx");
    private final Project project;
    private final MinecraftVersionMeta versionInfo;
    private final BundleMetadata serverBundleMetadata;
    private final boolean runtimeOnlyLog4j;
    private final boolean provideClient;
    private final boolean provideServer;

    public MinecraftLibraryProvider(MinecraftProvider minecraftProvider, Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        MinecraftJarConfiguration jarConfiguration = (MinecraftJarConfiguration)((Object)extension.getMinecraftJarConfiguration().get());
        this.project = project;
        this.versionInfo = minecraftProvider.getVersionInfo();
        this.serverBundleMetadata = minecraftProvider.getServerBundleMetadata();
        this.runtimeOnlyLog4j = (Boolean)extension.getRuntimeOnlyLog4j().get();
        this.provideClient = jarConfiguration.getSupportedEnvironments().contains("client");
        this.provideServer = jarConfiguration.getSupportedEnvironments().contains("server");
        assert (this.provideClient || this.provideServer);
    }

    private void addDependency(String configuration, Object dependency) {
        Dependency created = this.project.getDependencies().add(configuration, dependency);
        if (created instanceof ModuleDependency) {
            ModuleDependency md = (ModuleDependency)created;
            md.setTransitive(false);
        }
    }

    public void provide() {
        if (this.provideClient) {
            boolean overrideLWJGL;
            boolean hasNativesToExtract = this.versionInfo.hasNativesToExtract();
            boolean bl = overrideLWJGL = hasNativesToExtract && (LWJGLVersionOverride.overrideByDefault(this.versionInfo) || LWJGLVersionOverride.forceOverride(this.project) || Boolean.getBoolean("loom.test.lwjgloverride"));
            if (overrideLWJGL) {
                this.project.getLogger().warn("Loom is upgrading Minecraft's LWJGL version to {}", (Object)"3.3.1");
            }
            if (hasNativesToExtract) {
                this.project.getConfigurations().register("minecraftNatives", configuration -> configuration.setTransitive(false));
            }
            this.provideClientLibraries(overrideLWJGL, hasNativesToExtract);
            if (overrideLWJGL) {
                LWJGLVersionOverride.applyOverrides(this.project, IS_MACOS);
            }
        }
        if (this.provideServer) {
            this.provideServerLibraries();
        }
    }

    private void provideClientLibraries(boolean overrideLWJGL, boolean hasNativesToExtract) {
        boolean classpathArmNatives;
        boolean isArm = Architecture.CURRENT.isArm();
        boolean bl = classpathArmNatives = !hasNativesToExtract && isArm && !IS_MACOS;
        if (classpathArmNatives) {
            LoomRepositoryPlugin.forceLWJGLFromMavenCentral(this.project);
        }
        for (MinecraftVersionMeta.Library library : this.versionInfo.libraries()) {
            if (overrideLWJGL && library.name().startsWith("org.lwjgl")) continue;
            if (library.isValidForOS() && !library.hasNatives() && library.artifact() != null) {
                String name = library.name();
                if ("org.lwjgl.lwjgl:lwjgl:2.9.1-nightly-20130708-debug3".equals(name) || "org.lwjgl.lwjgl:lwjgl:2.9.1-nightly-20131017".equals(name)) {
                    LoomRepositoryPlugin.setupForLegacyVersions(this.project);
                }
                if (name.startsWith("org.ow2.asm:asm-all")) continue;
                if (this.runtimeOnlyLog4j && name.startsWith("org.apache.logging.log4j")) {
                    this.addDependency("minecraftRuntimeOnlyLibraries", name);
                    continue;
                }
                if (classpathArmNatives && name.startsWith("org.lwjgl:") && (name.endsWith("natives-windows") || name.endsWith("natives-linux"))) {
                    this.addDependency("minecraftLibraries", name + "-arm64");
                }
                this.addDependency("minecraftLibraries", name);
            }
            if (!library.hasNativesForOS()) continue;
            this.provideNativesForLibrary(library, overrideLWJGL, IS_MACOS);
        }
    }

    private void provideServerLibraries() {
        if (this.serverBundleMetadata != null) {
            for (BundleMetadata.Entry library : this.serverBundleMetadata.libraries()) {
                if (this.runtimeOnlyLog4j && library.name().startsWith("org.apache.logging.log4j")) {
                    this.addDependency("minecraftRuntimeOnlyLibraries", library.name());
                    continue;
                }
                this.addDependency("minecraftServerLibraries", library.name());
            }
        }
    }

    private void provideNativesForLibrary(MinecraftVersionMeta.Library library, boolean overrideLWJGL, boolean isMacOS) {
        MinecraftVersionMeta.Download nativeDownload = library.classifierForOS();
        if (nativeDownload == null) {
            return;
        }
        String path = nativeDownload.path();
        Matcher matcher = NATIVES_PATTERN.matcher(path);
        if (!matcher.find()) {
            this.project.getLogger().warn("Failed to match regex for natives path : " + path);
            return;
        }
        String group = matcher.group("group").replace("/", ".");
        String name = matcher.group("name");
        String version = matcher.group("version");
        String classifier = matcher.group("classifier");
        String dependencyNotation = "%s:%s:%s:%s".formatted(group, name, version, classifier);
        if (overrideLWJGL && isMacOS && "java-objc-bridge".equals(name)) {
            return;
        }
        this.project.getLogger().debug("Add native dependency '{}'", (Object)dependencyNotation);
        this.addDependency("minecraftNatives", dependencyNotation);
    }
}

