/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.ManifestVersion;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftLibraryProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.MirrorUtil;
import net.fabricmc.loom.util.download.DownloadBuilder;
import net.fabricmc.loom.util.download.DownloadExecutor;
import net.fabricmc.loom.util.download.GradleDownloadProgressListener;
import net.fabricmc.loom.util.gradle.ProgressGroup;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.jetbrains.annotations.Nullable;

public abstract class MinecraftProvider {
    private String minecraftVersion;
    private MinecraftVersionMeta versionInfo;
    private MinecraftLibraryProvider libraryProvider;
    private File workingDir;
    private File minecraftJson;
    private File minecraftClientJar;
    private File minecraftServerJar;
    private File minecraftExtractedServerJar;
    @Nullable
    private BundleMetadata serverBundleMetadata;
    private File versionManifestJson;
    private File experimentalVersionsJson;
    private final Project project;

    public MinecraftProvider(Project project) {
        this.project = project;
    }

    protected boolean provideClient() {
        return true;
    }

    protected boolean provideServer() {
        return true;
    }

    public void provide() throws Exception {
        DependencyInfo dependency = DependencyInfo.create(this.getProject(), "minecraft");
        this.minecraftVersion = dependency.getDependency().getVersion();
        this.initFiles();
        this.downloadMcJson();
        try (FileReader reader = new FileReader(this.minecraftJson);){
            this.versionInfo = (MinecraftVersionMeta)LoomGradlePlugin.OBJECT_MAPPER.readValue((Reader)reader, MinecraftVersionMeta.class);
        }
        this.downloadJars();
        if (this.provideServer()) {
            this.serverBundleMetadata = BundleMetadata.fromJar(this.minecraftServerJar.toPath());
        }
        this.libraryProvider = new MinecraftLibraryProvider(this, this.project);
        this.libraryProvider.provide();
    }

    protected void initFiles() {
        this.workingDir = new File(this.getExtension().getFiles().getUserCache(), this.minecraftVersion);
        this.workingDir.mkdirs();
        this.minecraftJson = this.file("minecraft-info.json");
        this.versionManifestJson = new File(this.getExtension().getFiles().getUserCache(), "version_manifest.json");
        this.experimentalVersionsJson = new File(this.getExtension().getFiles().getUserCache(), "experimental_version_manifest.json");
        if (this.provideClient()) {
            this.minecraftClientJar = this.file("minecraft-client.jar");
        }
        if (this.provideServer()) {
            this.minecraftServerJar = this.file("minecraft-server.jar");
            this.minecraftExtractedServerJar = this.file("minecraft-extracted_server.jar");
        }
    }

    private void downloadMcJson() throws IOException {
        String versionManifestUrl = MirrorUtil.getVersionManifests((ExtensionAware)this.getProject());
        String versionManifest = this.getExtension().download(versionManifestUrl).defaultCache().downloadString(this.versionManifestJson.toPath());
        ManifestVersion mcManifest = (ManifestVersion)LoomGradlePlugin.OBJECT_MAPPER.readValue(versionManifest, ManifestVersion.class);
        ManifestVersion.Versions version = null;
        if (this.getExtension().getCustomMinecraftManifest().isPresent()) {
            ManifestVersion.Versions customVersion = new ManifestVersion.Versions();
            customVersion.id = this.minecraftVersion;
            customVersion.url = (String)this.getExtension().getCustomMinecraftManifest().get();
            version = customVersion;
            this.getProject().getLogger().lifecycle("Using custom minecraft manifest");
        }
        if (version == null) {
            version = mcManifest.versions().stream().filter(versions -> versions.id.equalsIgnoreCase(this.minecraftVersion)).findFirst().orElse(null);
        }
        if (version == null) {
            version = this.findExperimentalVersion();
        }
        if (version == null) {
            throw new RuntimeException("Failed to find minecraft version: " + this.minecraftVersion);
        }
        this.getProject().getLogger().debug("Downloading Minecraft {} manifest", (Object)this.minecraftVersion);
        DownloadBuilder download = this.getExtension().download(version.url);
        if (version.sha1 != null) {
            download.sha1(version.sha1);
        } else {
            download.defaultCache();
        }
        download.downloadPath(this.minecraftJson.toPath());
    }

    private ManifestVersion.Versions findExperimentalVersion() throws IOException {
        String expVersionManifest = this.getExtension().download(MirrorUtil.getExperimentalVersions((ExtensionAware)this.getProject())).defaultCache().downloadString(this.experimentalVersionsJson.toPath());
        ManifestVersion expManifest = (ManifestVersion)LoomGradlePlugin.OBJECT_MAPPER.readValue(expVersionManifest, ManifestVersion.class);
        ManifestVersion.Versions result = expManifest.versions().stream().filter(versions -> versions.id.equalsIgnoreCase(this.minecraftVersion)).findFirst().orElse(null);
        if (result != null) {
            this.getProject().getLogger().lifecycle("Using fallback experimental version {}", new Object[]{this.minecraftVersion});
        }
        return result;
    }

    private void downloadJars() throws IOException {
        try (ProgressGroup progressGroup = new ProgressGroup(this.getProject(), "Download Minecraft jars");
             DownloadExecutor executor = new DownloadExecutor(2);){
            if (this.provideClient()) {
                MinecraftVersionMeta.Download client = this.versionInfo.download("client");
                this.getExtension().download(client.url()).sha1(client.sha1()).progress(new GradleDownloadProgressListener("Minecraft client", progressGroup::createProgressLogger)).downloadPathAsync(this.minecraftClientJar.toPath(), executor);
            }
            if (this.provideServer()) {
                MinecraftVersionMeta.Download server = this.versionInfo.download("server");
                this.getExtension().download(server.url()).sha1(server.sha1()).progress(new GradleDownloadProgressListener("Minecraft server", progressGroup::createProgressLogger)).downloadPathAsync(this.minecraftServerJar.toPath(), executor);
            }
        }
    }

    protected final void extractBundledServerJar() throws IOException {
        Preconditions.checkArgument((boolean)this.provideServer(), (Object)"Not configured to provide server jar");
        Objects.requireNonNull(this.getServerBundleMetadata(), "Cannot bundled mc jar from none bundled server jar");
        this.getLogger().info(":Extracting server jar from bootstrap");
        if (this.getServerBundleMetadata().versions().size() != 1) {
            throw new UnsupportedOperationException("Expected only 1 version in META-INF/versions.list, but got %d".formatted(this.getServerBundleMetadata().versions().size()));
        }
        this.getServerBundleMetadata().versions().get(0).unpackEntry(this.minecraftServerJar.toPath(), this.getMinecraftExtractedServerJar().toPath(), this.project);
    }

    public File workingDir() {
        return this.workingDir;
    }

    public File dir(String path) {
        File dir = this.file(path);
        dir.mkdirs();
        return dir;
    }

    public File file(String path) {
        return new File(this.workingDir(), path);
    }

    public Path path(String path) {
        return this.file(path).toPath();
    }

    public File getMinecraftClientJar() {
        Preconditions.checkArgument((boolean)this.provideClient(), (Object)"Not configured to provide client jar");
        return this.minecraftClientJar;
    }

    @Nullable
    public File getMinecraftExtractedServerJar() {
        Preconditions.checkArgument((boolean)this.provideServer(), (Object)"Not configured to provide server jar");
        return this.minecraftExtractedServerJar;
    }

    public File getMinecraftServerJar() {
        Preconditions.checkArgument((boolean)this.provideServer(), (Object)"Not configured to provide server jar");
        return this.minecraftServerJar;
    }

    public String minecraftVersion() {
        return this.minecraftVersion;
    }

    public MinecraftVersionMeta getVersionInfo() {
        return this.versionInfo;
    }

    @Nullable
    public BundleMetadata getServerBundleMetadata() {
        return this.serverBundleMetadata;
    }

    protected Logger getLogger() {
        return this.getProject().getLogger();
    }

    public abstract List<Path> getMinecraftJars();

    protected Project getProject() {
        return this.project;
    }

    protected LoomGradleExtension getExtension() {
        return LoomGradleExtension.get(this.getProject());
    }

    public boolean refreshDeps() {
        return this.getExtension().refreshDeps();
    }
}

