/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.CompileConfiguration;
import net.fabricmc.loom.configuration.RemapConfigurations;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.tasks.Jar;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MinecraftSourceSets {
    public static MinecraftSourceSets get(Project project) {
        return LoomGradleExtension.get(project).areEnvironmentSourceSetsSplit() ? Split.INSTANCE : Single.INSTANCE;
    }

    public abstract void applyDependencies(BiConsumer<String, String> var1, List<String> var2);

    public abstract String getCombinedSourceSetName();

    public abstract String getSourceSetForEnv(String var1);

    protected abstract List<String> getAllSourceSetNames();

    public void evaluateSplit(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Preconditions.checkArgument((boolean)extension.areEnvironmentSourceSetsSplit());
        Split.INSTANCE.evaluate(project);
    }

    public abstract void afterEvaluate(Project var1);

    protected void createSourceSets(Project project) {
        for (String name : this.getAllSourceSetNames()) {
            project.getConfigurations().register(name, configuration -> configuration.setTransitive(false));
            CompileConfiguration.extendsFrom(name, "loaderLibraries", project);
        }
    }

    public static final class Split
    extends MinecraftSourceSets {
        private static final String MINECRAFT_COMMON_NAMED = "minecraftCommonNamed";
        private static final String MINECRAFT_CLIENT_ONLY_NAMED = "minecraftClientOnlyNamed";
        private static final String MINECRAFT_COMBINED_NAMED = "minecraftCombinedNamed";
        private static final String CLIENT_ONLY_SOURCE_SET_NAME = "client";
        private static final Split INSTANCE = new Split();

        @Override
        public void applyDependencies(BiConsumer<String, String> consumer, List<String> targets) {
            Preconditions.checkArgument((targets.size() == 2 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)targets.contains("common"));
            Preconditions.checkArgument((boolean)targets.contains("clientOnly"));
            consumer.accept(MINECRAFT_COMMON_NAMED, "common");
            consumer.accept(MINECRAFT_CLIENT_ONLY_NAMED, "clientOnly");
        }

        @Override
        public String getCombinedSourceSetName() {
            return MINECRAFT_COMBINED_NAMED;
        }

        @Override
        public String getSourceSetForEnv(String env) {
            return env.equals(CLIENT_ONLY_SOURCE_SET_NAME) ? CLIENT_ONLY_SOURCE_SET_NAME : "main";
        }

        @Override
        protected List<String> getAllSourceSetNames() {
            return List.of(MINECRAFT_COMMON_NAMED, MINECRAFT_CLIENT_ONLY_NAMED, MINECRAFT_COMBINED_NAMED);
        }

        private void evaluate(Project project) {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            this.createSourceSets(project);
            CompileConfiguration.extendsFrom(MINECRAFT_COMBINED_NAMED, MINECRAFT_COMMON_NAMED, project);
            CompileConfiguration.extendsFrom(MINECRAFT_COMBINED_NAMED, MINECRAFT_CLIENT_ONLY_NAMED, project);
            SourceSet mainSourceSet = SourceSetHelper.getMainSourceSet(project);
            SourceSet clientOnlySourceSet = SourceSetHelper.createSourceSet(CLIENT_ONLY_SOURCE_SET_NAME, project);
            CompileConfiguration.extendsFrom(List.of(mainSourceSet.getCompileClasspathConfigurationName(), mainSourceSet.getRuntimeClasspathConfigurationName()), MINECRAFT_COMMON_NAMED, project);
            CompileConfiguration.extendsFrom(List.of(clientOnlySourceSet.getCompileClasspathConfigurationName(), clientOnlySourceSet.getRuntimeClasspathConfigurationName()), MINECRAFT_CLIENT_ONLY_NAMED, project);
            CompileConfiguration.extendsFrom(MINECRAFT_CLIENT_ONLY_NAMED, MINECRAFT_COMMON_NAMED, project);
            clientOnlySourceSet.setCompileClasspath(clientOnlySourceSet.getCompileClasspath().plus(mainSourceSet.getCompileClasspath()).plus((FileCollection)mainSourceSet.getOutput()));
            clientOnlySourceSet.setRuntimeClasspath(clientOnlySourceSet.getRuntimeClasspath().plus(mainSourceSet.getRuntimeClasspath()).plus((FileCollection)mainSourceSet.getOutput()));
            RemapConfigurations.configureClientConfigurations(project, clientOnlySourceSet);
            project.getTasks().named(mainSourceSet.getJarTaskName(), Jar.class).configure(jar -> {
                jar.from(new Object[]{clientOnlySourceSet.getOutput().getClassesDirs()});
                jar.from(new Object[]{clientOnlySourceSet.getOutput().getResourcesDir()});
                jar.dependsOn(new Object[]{project.getTasks().named(clientOnlySourceSet.getProcessResourcesTaskName())});
            });
            project.getTasks().withType(AbstractRemapJarTask.class).configureEach(remapJarTask -> remapJarTask.getClasspath().from(new Object[]{project.getConfigurations().getByName(clientOnlySourceSet.getCompileClasspathConfigurationName())}));
            project.getTasks().configureEach(task -> {
                if (!mainSourceSet.getSourcesJarTaskName().equals(task.getName()) || !(task instanceof Jar)) {
                    return;
                }
                Jar jar = (Jar)task;
                jar.from(new Object[]{clientOnlySourceSet.getAllSource()});
            });
            extension.getInterfaceInjection().getInterfaceInjectionSourceSets().add((Object)clientOnlySourceSet);
        }

        @Override
        public void afterEvaluate(Project project) {
        }

        public static SourceSet getClientSourceSet(Project project) {
            Preconditions.checkArgument((boolean)LoomGradleExtension.get(project).areEnvironmentSourceSetsSplit(), (Object)"Cannot get client only sourceset as project is not split");
            return SourceSetHelper.getSourceSetByName(CLIENT_ONLY_SOURCE_SET_NAME, project);
        }
    }

    public static final class Single
    extends MinecraftSourceSets {
        private static final String MINECRAFT_NAMED = "minecraftNamed";
        private static final Single INSTANCE = new Single();

        @Override
        public void applyDependencies(BiConsumer<String, String> consumer, List<String> targets) {
            for (String target : targets) {
                consumer.accept(MINECRAFT_NAMED, target);
            }
        }

        @Override
        public String getCombinedSourceSetName() {
            return MINECRAFT_NAMED;
        }

        @Override
        public String getSourceSetForEnv(String env) {
            return "main";
        }

        @Override
        protected List<String> getAllSourceSetNames() {
            return List.of(MINECRAFT_NAMED);
        }

        @Override
        public void afterEvaluate(Project project) {
            this.createSourceSets(project);
            CompileConfiguration.extendsFrom(List.of("compileClasspath", "runtimeClasspath", "testCompileClasspath", "testRuntimeClasspath"), MINECRAFT_NAMED, project);
        }
    }
}

