/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.util.Architecture;
import net.fabricmc.loom.util.OperatingSystem;

public record MinecraftVersionMeta(Object arguments, AssetIndex assetIndex, String assets, int complianceLevel, Map<String, Download> downloads, String id, List<Library> libraries, Object logging, String mainClass, int minimumLauncherVersion, String releaseTime, String time, String type) {
    public Download download(String key) {
        return this.downloads().get(key);
    }

    public boolean isVersionOrNewer(String releaseTime) {
        return this.releaseTime().compareTo(releaseTime) >= 0;
    }

    public boolean hasNativesToExtract() {
        return this.libraries.stream().anyMatch(Library::hasNatives);
    }

    public record AssetIndex(String id, long totalSize, String path, String sha1, long size, String url) {
        public String fabricId(String version) {
            return this.id.equals(version) ? version : version + "-" + this.id;
        }
    }

    public record Download(String path, String sha1, long size, String url) {
        public File relativeFile(File baseDirectory) {
            Objects.requireNonNull(this.path(), "Cannot get relative file from a null path");
            return new File(baseDirectory, this.path());
        }
    }

    public record OS(String name) {
        public boolean isValidForOS() {
            return this.name() == null || this.name().equalsIgnoreCase(OperatingSystem.CURRENT_OS);
        }
    }

    public record Rule(String action, OS os) {
        public boolean appliesToOS() {
            return this.os() == null || this.os().isValidForOS();
        }

        public boolean isAllowed() {
            return this.action().equals("allow");
        }
    }

    public record Downloads(Download artifact, Map<String, Download> classifiers) {
        public Download classifier(String os) {
            return this.classifiers.get(os);
        }
    }

    public record Library(Downloads downloads, String name, Map<String, String> natives, List<Rule> rules, Object extract) {
        public boolean isValidForOS() {
            if (this.rules == null) {
                return true;
            }
            boolean valid = false;
            for (Rule rule : this.rules) {
                if (!rule.appliesToOS()) continue;
                valid = rule.isAllowed();
            }
            return valid;
        }

        public boolean hasNatives() {
            return this.natives != null;
        }

        public boolean hasNativesForOS() {
            if (!this.hasNatives()) {
                return false;
            }
            if (this.classifierForOS() == null) {
                return false;
            }
            return this.isValidForOS();
        }

        public Download classifierForOS() {
            Object classifier = this.natives.get(OperatingSystem.CURRENT_OS);
            if (Architecture.CURRENT.isArm()) {
                classifier = (String)classifier + "-arm64";
            }
            return this.downloads().classifier((String)classifier);
        }

        public Download artifact() {
            if (this.downloads() == null) {
                return null;
            }
            return this.downloads().artifact();
        }
    }
}

