/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;

public final class SingleJarMinecraftProvider
extends MinecraftProvider {
    private final Environment environment;
    private Path minecraftEnvOnlyJar;

    private SingleJarMinecraftProvider(Project project, Environment environment) {
        super(project);
        this.environment = environment;
    }

    public static SingleJarMinecraftProvider server(Project project) {
        return new SingleJarMinecraftProvider(project, new Server());
    }

    public static SingleJarMinecraftProvider client(Project project) {
        return new SingleJarMinecraftProvider(project, new Client());
    }

    @Override
    protected void initFiles() {
        super.initFiles();
        this.minecraftEnvOnlyJar = this.path("minecraft-%s-only.jar".formatted(this.environment.name()));
    }

    @Override
    public List<Path> getMinecraftJars() {
        return List.of(this.minecraftEnvOnlyJar);
    }

    @Override
    public void provide() throws Exception {
        boolean requiresRefresh;
        super.provide();
        boolean bl = requiresRefresh = this.getExtension().refreshDeps() || Files.notExists(this.minecraftEnvOnlyJar, new LinkOption[0]);
        if (!requiresRefresh) {
            return;
        }
        Path inputJar = this.environment.getInputJar(this);
        TinyRemapper remapper = null;
        try {
            remapper = TinyRemapper.newRemapper().build();
            Files.deleteIfExists(this.minecraftEnvOnlyJar);
            try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(this.minecraftEnvOnlyJar).build();){
                outputConsumer.addNonClassFiles(inputJar, NonClassCopyMode.FIX_META_INF, remapper);
                remapper.readInputs(new Path[]{inputJar});
                remapper.apply((BiConsumer)outputConsumer);
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(this.minecraftEnvOnlyJar);
            throw new RuntimeException("Failed to process %s only jar".formatted(this.environment.name()), e);
        }
        finally {
            if (remapper != null) {
                remapper.finish();
            }
        }
    }

    @Override
    protected boolean provideClient() {
        return this.environment instanceof Client;
    }

    @Override
    protected boolean provideServer() {
        return this.environment instanceof Server;
    }

    public Path getMinecraftEnvOnlyJar() {
        return this.minecraftEnvOnlyJar;
    }

    private static interface Environment {
        public String name();

        public Path getInputJar(SingleJarMinecraftProvider var1) throws Exception;
    }

    private static final class Server
    implements Environment {
        private Server() {
        }

        @Override
        public String name() {
            return "server";
        }

        @Override
        public Path getInputJar(SingleJarMinecraftProvider provider) throws Exception {
            BundleMetadata serverBundleMetadata = provider.getServerBundleMetadata();
            if (serverBundleMetadata == null) {
                return provider.getMinecraftServerJar().toPath();
            }
            provider.extractBundledServerJar();
            return provider.getMinecraftExtractedServerJar().toPath();
        }
    }

    private static final class Client
    implements Environment {
        private Client() {
        }

        @Override
        public String name() {
            return "client";
        }

        @Override
        public Path getInputJar(SingleJarMinecraftProvider provider) throws Exception {
            return provider.getMinecraftClientJar().toPath();
        }
    }
}

