/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.MappingsProviderImpl;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.SignatureFixerApplyVisitor;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.util.TinyRemapperHelper;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;

public abstract class AbstractMappedMinecraftProvider<M extends MinecraftProvider>
implements MappedMinecraftProvider.ProviderImpl {
    protected final M minecraftProvider;
    private final Project project;
    protected final LoomGradleExtension extension;

    public AbstractMappedMinecraftProvider(Project project, M minecraftProvider) {
        this.project = project;
        this.minecraftProvider = minecraftProvider;
        this.extension = LoomGradleExtension.get(project);
    }

    public abstract MappingsNamespace getTargetNamespace();

    public abstract List<RemappedJars> getRemappedJars();

    public List<String> getDependencyTargets() {
        return Collections.emptyList();
    }

    public void provide(boolean applyDependencies) throws Exception {
        List<RemappedJars> remappedJars = this.getRemappedJars();
        assert (!remappedJars.isEmpty());
        if (!this.areOutputsValid(remappedJars) || this.extension.refreshDeps()) {
            try {
                this.remapInputs(remappedJars);
            }
            catch (Throwable t) {
                this.cleanOutputs(remappedJars);
                throw new RuntimeException("Failed to remap minecraft", t);
            }
        }
        if (applyDependencies) {
            List<String> dependencyTargets = this.getDependencyTargets();
            if (dependencyTargets.isEmpty()) {
                return;
            }
            MinecraftSourceSets.get(this.getProject()).applyDependencies((configuration, name) -> this.getProject().getDependencies().add(configuration, (Object)this.getDependencyNotation((String)name)), dependencyTargets);
        }
    }

    protected abstract Path getDirectory();

    @Override
    public Path getJar(String name) {
        return this.getDirectory().resolve(this.getName(name) + ".jar");
    }

    protected String getName(String name) {
        return "minecraft-%s-%s".formatted(name, this.getTargetNamespace().toString());
    }

    protected String getDependencyNotation(String name) {
        return "net.minecraft:%s:%s/%s".formatted(this.getName(name), this.extension.getMinecraftProvider().minecraftVersion(), this.extension.getMappingsProvider().mappingsIdentifier());
    }

    private boolean areOutputsValid(List<RemappedJars> remappedJars) {
        for (RemappedJars remappedJar : remappedJars) {
            if (Files.exists(remappedJar.outputJar(), new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    private void remapInputs(List<RemappedJars> remappedJars) throws IOException {
        this.cleanOutputs(remappedJars);
        for (RemappedJars remappedJar : remappedJars) {
            this.remapJar(remappedJar);
        }
    }

    private void remapJar(RemappedJars remappedJars) throws IOException {
        MappingsProviderImpl mappingsProvider = this.extension.getMappingsProvider();
        String fromM = remappedJars.sourceNamespace().toString();
        String toM = this.getTargetNamespace().toString();
        Files.deleteIfExists(remappedJars.outputJar());
        Map<String, String> remappedSignatures = SignatureFixerApplyVisitor.getRemappedSignatures(this.getTargetNamespace() == MappingsNamespace.INTERMEDIARY, mappingsProvider, this.project, toM);
        TinyRemapper remapper = TinyRemapperHelper.getTinyRemapper(this.project, fromM, toM, true, builder -> {
            builder.extraPostApplyVisitor((TinyRemapper.ApplyVisitorProvider)new SignatureFixerApplyVisitor(remappedSignatures));
            this.configureRemapper(remappedJars, (TinyRemapper.Builder)builder);
        });
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(remappedJars.outputJar()).build();){
            outputConsumer.addNonClassFiles(remappedJars.inputJar());
            remapper.readClassPath(TinyRemapperHelper.getMinecraftDependencies(this.project));
            for (Path path : remappedJars.remapClasspath()) {
                remapper.readClassPath(new Path[]{path});
            }
            remapper.readInputs(new Path[]{remappedJars.inputJar()});
            remapper.apply((BiConsumer)outputConsumer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap JAR " + remappedJars.inputJar() + " with mappings from " + mappingsProvider.tinyMappings, e);
        }
        finally {
            remapper.finish();
        }
    }

    protected void configureRemapper(RemappedJars remappedJars, TinyRemapper.Builder tinyRemapperBuilder) {
    }

    private void cleanOutputs(List<RemappedJars> remappedJars) throws IOException {
        for (RemappedJars remappedJar : remappedJars) {
            Files.deleteIfExists(remappedJar.outputJar());
        }
    }

    public Project getProject() {
        return this.project;
    }

    public M getMinecraftProvider() {
        return this.minecraftProvider;
    }

    public record RemappedJars(Path inputJar, Path outputJar, MappingsNamespace sourceNamespace, Path[] remapClasspath) {
    }
}

