/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.nio.file.Path;
import java.util.List;

public interface MappedMinecraftProvider {
    public List<Path> getMinecraftJars();

    public static interface SingleJar
    extends ProviderImpl {
        public String env();

        default public String envName() {
            return "%sOnly".formatted(this.env());
        }

        default public Path getEnvOnlyJar() {
            return this.getJar(this.envName());
        }

        @Override
        default public List<Path> getMinecraftJars() {
            return List.of(this.getEnvOnlyJar());
        }
    }

    public static interface Split
    extends ProviderImpl {
        public static final String COMMON = "common";
        public static final String CLIENT_ONLY = "clientOnly";

        default public Path getCommonJar() {
            return this.getJar(COMMON);
        }

        default public Path getClientOnlyJar() {
            return this.getJar(CLIENT_ONLY);
        }

        @Override
        default public List<Path> getMinecraftJars() {
            return List.of(this.getCommonJar(), this.getClientOnlyJar());
        }
    }

    public static interface Merged
    extends ProviderImpl {
        public static final String MERGED = "merged";

        default public Path getMergedJar() {
            return this.getJar(MERGED);
        }

        @Override
        default public List<Path> getMinecraftJars() {
            return List.of(this.getMergedJar());
        }
    }

    public static interface ProviderImpl
    extends MappedMinecraftProvider {
        public Path getJar(String var1);
    }
}

