/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.processors.JarProcessorManager;
import net.fabricmc.loom.configuration.providers.minecraft.MergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SplitMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.AbstractMappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;

public abstract class ProcessedNamedMinecraftProvider<M extends MinecraftProvider, P extends NamedMinecraftProvider<M>>
extends NamedMinecraftProvider<M> {
    private final P parentMinecraftProvider;
    private final JarProcessorManager jarProcessorManager;
    private final String projectMappedName;
    private final Path projectMappedDir;

    public ProcessedNamedMinecraftProvider(P parentMinecraftProvide, JarProcessorManager jarProcessorManager) {
        super(((AbstractMappedMinecraftProvider)parentMinecraftProvide).getProject(), ((AbstractMappedMinecraftProvider)parentMinecraftProvide).getMinecraftProvider());
        this.parentMinecraftProvider = parentMinecraftProvide;
        this.jarProcessorManager = jarProcessorManager;
        this.projectMappedName = "minecraft-project-%s-".formatted(this.getProject().getPath().replace(':', '@'));
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        this.projectMappedDir = extension.getFiles().getRootProjectPersistentCache().toPath().resolve(((MinecraftProvider)this.getMinecraftProvider()).minecraftVersion()).resolve(extension.getMappingsProvider().mappingsIdentifier());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void provide(boolean applyDependencies) throws Exception {
        this.parentMinecraftProvider.provide(false);
        inputJars = this.parentMinecraftProvider.getMinecraftJars();
        if (this.extension.refreshDeps()) ** GOTO lbl-1000
        if (inputJars.stream().map((Function<Path, Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getProcessedPath(java.nio.file.Path ), (Ljava/nio/file/Path;)Ljava/nio/file/Path;)((ProcessedNamedMinecraftProvider)this)).map((Function<Path, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toFile(), (Ljava/nio/file/Path;)Ljava/io/File;)()).anyMatch((Predicate<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInvalid(java.io.File ), (Ljava/io/File;)Z)((JarProcessorManager)this.jarProcessorManager))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = requiresProcessing = false;
        }
        if (requiresProcessing) {
            try {
                Files.createDirectories(this.projectMappedDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create project mapped dir", e);
            }
            for (Path inputJar : inputJars) {
                outputJar = this.getProcessedPath(inputJar);
                this.deleteSimilarJars(outputJar);
                Files.copy(inputJar, outputJar, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                this.jarProcessorManager.process(outputJar.toFile());
            }
        }
        if (applyDependencies) {
            dependencyTargets = this.parentMinecraftProvider.getDependencyTargets();
            if (dependencyTargets.isEmpty()) {
                return;
            }
            MinecraftSourceSets.get(this.getProject()).applyDependencies((BiConsumer<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$provide$0(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((ProcessedNamedMinecraftProvider)this), dependencyTargets);
        }
    }

    private void deleteSimilarJars(Path jar) throws IOException {
        Files.deleteIfExists(jar);
        for (Path path2 : Files.list(jar.getParent()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().startsWith(jar.getFileName().toString().replace(".jar", ""))).toList()) {
            Files.deleteIfExists(path2);
        }
    }

    @Override
    protected String getName(String name) {
        return "%s%s-%s".formatted(this.projectMappedName, name, this.getTargetNamespace().toString());
    }

    @Override
    public Path getJar(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractMappedMinecraftProvider.RemappedJars> getRemappedJars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Path> getMinecraftJars() {
        return this.getParentMinecraftProvider().getMinecraftJars().stream().map(this::getProcessedPath).toList();
    }

    public P getParentMinecraftProvider() {
        return this.parentMinecraftProvider;
    }

    public Path getProcessedPath(Path input) {
        return this.projectMappedDir.resolve(input.getFileName().toString().replace("minecraft-", this.projectMappedName));
    }

    private /* synthetic */ void lambda$provide$0(String configuration, String name) {
        this.getProject().getDependencies().add(configuration, (Object)this.getDependencyNotation(name));
    }

    public static final class SingleJarImpl
    extends ProcessedNamedMinecraftProvider<SingleJarMinecraftProvider, NamedMinecraftProvider.SingleJarImpl>
    implements MappedMinecraftProvider.SingleJar {
        private final String env;

        private SingleJarImpl(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, JarProcessorManager jarProcessorManager, String env) {
            super(parentMinecraftProvide, jarProcessorManager);
            this.env = env;
        }

        public static SingleJarImpl server(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, JarProcessorManager jarProcessorManager) {
            return new SingleJarImpl(parentMinecraftProvide, jarProcessorManager, "server");
        }

        public static SingleJarImpl client(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, JarProcessorManager jarProcessorManager) {
            return new SingleJarImpl(parentMinecraftProvide, jarProcessorManager, "client");
        }

        @Override
        public Path getEnvOnlyJar() {
            return this.getProcessedPath(((NamedMinecraftProvider.SingleJarImpl)this.getParentMinecraftProvider()).getEnvOnlyJar());
        }

        @Override
        public String env() {
            return this.env;
        }
    }

    public static final class SplitImpl
    extends ProcessedNamedMinecraftProvider<SplitMinecraftProvider, NamedMinecraftProvider.SplitImpl>
    implements MappedMinecraftProvider.Split {
        public SplitImpl(NamedMinecraftProvider.SplitImpl parentMinecraftProvide, JarProcessorManager jarProcessorManager) {
            super(parentMinecraftProvide, jarProcessorManager);
        }

        @Override
        public Path getCommonJar() {
            return this.getProcessedPath(((NamedMinecraftProvider.SplitImpl)this.getParentMinecraftProvider()).getCommonJar());
        }

        @Override
        public Path getClientOnlyJar() {
            return this.getProcessedPath(((NamedMinecraftProvider.SplitImpl)this.getParentMinecraftProvider()).getClientOnlyJar());
        }
    }

    public static final class MergedImpl
    extends ProcessedNamedMinecraftProvider<MergedMinecraftProvider, NamedMinecraftProvider.MergedImpl>
    implements MappedMinecraftProvider.Merged {
        public MergedImpl(NamedMinecraftProvider.MergedImpl parentMinecraftProvide, JarProcessorManager jarProcessorManager) {
            super(parentMinecraftProvide, jarProcessorManager);
        }

        @Override
        public Path getMergedJar() {
            return this.getProcessedPath(((NamedMinecraftProvider.MergedImpl)this.getParentMinecraftProvider()).getMergedJar());
        }
    }
}

