/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loom.util.IOStringConsumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class LineNumberRemapper {
    private final Map<String, RClass> lineMap = new HashMap<String, RClass>();

    public void readMappings(File lineMappings) {
        try (BufferedReader reader = new BufferedReader(new FileReader(lineMappings));){
            RClass clazz = null;
            String line = null;
            int i = 0;
            try {
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    String[] segs = line.trim().split("\t");
                    if (line.charAt(0) != '\t') {
                        clazz = this.lineMap.computeIfAbsent(segs[0], RClass::new);
                        clazz.maxLine = Integer.parseInt(segs[1]);
                        clazz.maxLineDest = Integer.parseInt(segs[2]);
                    } else {
                        clazz.lineMap.put(Integer.parseInt(segs[0]), Integer.parseInt(segs[1]));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(MessageFormat.format("Exception reading mapping line @{0}: {1}", i, line), e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception reading LineMappings file.", e);
        }
    }

    public void process(final IOStringConsumer logger, final Path input, final Path output) throws IOException {
        Files.walkFileTree(input, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fName;
                String rel = input.relativize(file).toString();
                Path dst = output.resolve(rel);
                Path parent = dst.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                if ((fName = file.getFileName().toString()).endsWith(".class")) {
                    int dollarPos;
                    if (Files.exists(dst, new LinkOption[0])) {
                        Files.delete(dst);
                    }
                    String idx = rel.substring(0, rel.length() - 6);
                    if (logger != null) {
                        logger.accept("Remapping " + idx);
                    }
                    if ((dollarPos = idx.indexOf(36)) >= 0) {
                        idx = idx.substring(0, dollarPos);
                    }
                    if (LineNumberRemapper.this.lineMap.containsKey(idx)) {
                        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                            ClassReader reader = new ClassReader(is);
                            ClassWriter writer = new ClassWriter(0);
                            reader.accept((ClassVisitor)new LineNumberVisitor(589824, (ClassVisitor)writer, LineNumberRemapper.this.lineMap.get(idx)), 0);
                            Files.write(dst, writer.toByteArray(), new OpenOption[0]);
                            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                            return fileVisitResult;
                        }
                    }
                }
                Files.copy(file, dst, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static class RClass {
        private final String name;
        private int maxLine;
        private int maxLineDest;
        private final Map<Integer, Integer> lineMap = new HashMap<Integer, Integer>();

        private RClass(String name) {
            this.name = name;
        }
    }

    private static class LineNumberVisitor
    extends ClassVisitor {
        private final RClass rClass;

        LineNumberVisitor(int api, ClassVisitor classVisitor, RClass rClass) {
            super(api, classVisitor);
            this.rClass = rClass;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                public void visitLineNumber(int line, Label start) {
                    int tLine = line;
                    if (tLine <= 0) {
                        super.visitLineNumber(line, start);
                    } else if (tLine >= rClass.maxLine) {
                        super.visitLineNumber(rClass.maxLineDest, start);
                    } else {
                        Integer matchedLine = null;
                        while (tLine <= rClass.maxLine && (matchedLine = rClass.lineMap.get(tLine)) == null) {
                            ++tLine;
                        }
                        super.visitLineNumber(matchedLine != null ? matchedLine : rClass.maxLineDest, start);
                    }
                }
            };
        }
    }
}

