/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.kotlin.remapping;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmLambda;
import kotlinx.metadata.KmLambdaVisitor;
import kotlinx.metadata.KmPackage;
import kotlinx.metadata.KmPackageVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import net.fabricmc.loom.kotlin.remapping.KotlinMetadataRemappingClassVisitor;
import net.fabricmc.loom.kotlin.remapping.RemappingKmVisitors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AnnotationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u001c\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/fabricmc/loom/kotlin/remapping/KotlinClassMetadataRemappingAnnotationVisitor;", "Lorg/objectweb/asm/tree/AnnotationNode;", "remapper", "Lorg/objectweb/asm/commons/Remapper;", "next", "Lorg/objectweb/asm/AnnotationVisitor;", "className", "", "(Lorg/objectweb/asm/commons/Remapper;Lorg/objectweb/asm/AnnotationVisitor;Ljava/lang/String;)V", "_name", "getClassName", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getNext", "()Lorg/objectweb/asm/AnnotationVisitor;", "readHeader", "Lkotlinx/metadata/jvm/KotlinClassHeader;", "validateKotlinClassHeader", "", "remapped", "original", "visit", "name", "value", "", "visitEnd", "writeClassHeader", "header", "fabric-loom"})
public final class KotlinClassMetadataRemappingAnnotationVisitor
extends AnnotationNode {
    @NotNull
    private final Remapper remapper;
    @NotNull
    private final AnnotationVisitor next;
    @Nullable
    private final String className;
    private final Logger logger;
    @Nullable
    private String _name;

    public KotlinClassMetadataRemappingAnnotationVisitor(@NotNull Remapper remapper, @NotNull AnnotationVisitor next, @Nullable String className) {
        Intrinsics.checkNotNullParameter((Object)remapper, (String)"remapper");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        super(589824, KotlinMetadataRemappingClassVisitor.Companion.getANNOTATION_DESCRIPTOR());
        this.remapper = remapper;
        this.next = next;
        this.className = className;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final AnnotationVisitor getNext() {
        return this.next;
    }

    @Nullable
    public final String getClassName() {
        return this.className;
    }

    public void visit(@Nullable String name, @Nullable Object value) {
        super.visit(name, value);
        this._name = name;
    }

    public void visitEnd() {
        KotlinClassMetadata metadata;
        KotlinVersion currentMinorVersion;
        super.visitEnd();
        KotlinClassHeader kotlinClassHeader = this.readHeader();
        if (kotlinClassHeader == null) {
            return;
        }
        KotlinClassHeader header = kotlinClassHeader;
        KotlinVersion headerVersion = new KotlinVersion(header.getMetadataVersion()[0], header.getMetadataVersion()[1], 0);
        if (!Intrinsics.areEqual((Object)headerVersion, (Object)(currentMinorVersion = new KotlinVersion(KotlinVersion.CURRENT.getMajor(), KotlinVersion.CURRENT.getMinor(), 0)))) {
            this.logger.info("Kotlin metadata for class (" + this.className + ") as it was built using a different major Kotlin version (" + header.getMetadataVersion()[0] + "." + header.getMetadataVersion()[1] + ".x) while the remapper is using (" + KotlinVersion.CURRENT + ").");
        }
        if ((metadata = KotlinClassMetadata.Companion.read(header)) instanceof KotlinClassMetadata.Class) {
            KmClass klass = ((KotlinClassMetadata.Class)metadata).toKmClass();
            KotlinClassMetadata.Class.Writer writer = new KotlinClassMetadata.Class.Writer();
            klass.accept((KmClassVisitor)new RemappingKmVisitors(this.remapper).new RemappingKmVisitors.RemappingKmClassVisitor((KmClassVisitor)writer));
            KotlinClassHeader remapped = writer.write(header.getMetadataVersion(), header.getExtraInt()).getHeader();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if (metadata instanceof KotlinClassMetadata.SyntheticClass) {
            KmLambda klambda = ((KotlinClassMetadata.SyntheticClass)metadata).toKmLambda();
            if (klambda != null) {
                KotlinClassMetadata.SyntheticClass.Writer writer = new KotlinClassMetadata.SyntheticClass.Writer();
                klambda.accept((KmLambdaVisitor)new RemappingKmVisitors(this.remapper).new RemappingKmVisitors.RemappingKmLambdaVisitor((KmLambdaVisitor)writer));
                KotlinClassHeader remapped = writer.write(header.getMetadataVersion(), header.getExtraInt()).getHeader();
                this.writeClassHeader(remapped);
                this.validateKotlinClassHeader(remapped, header);
            } else {
                this.accept(this.next);
            }
        } else if (metadata instanceof KotlinClassMetadata.FileFacade) {
            KmPackage kpackage = ((KotlinClassMetadata.FileFacade)metadata).toKmPackage();
            KotlinClassMetadata.FileFacade.Writer writer = new KotlinClassMetadata.FileFacade.Writer();
            kpackage.accept((KmPackageVisitor)new RemappingKmVisitors(this.remapper).new RemappingKmVisitors.RemappingKmPackageVisitor((KmPackageVisitor)writer));
            KotlinClassHeader remapped = writer.write(header.getMetadataVersion(), header.getExtraInt()).getHeader();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if (metadata instanceof KotlinClassMetadata.MultiFileClassPart) {
            KmPackage kpackage = ((KotlinClassMetadata.MultiFileClassPart)metadata).toKmPackage();
            KotlinClassMetadata.MultiFileClassPart.Writer writer = new KotlinClassMetadata.MultiFileClassPart.Writer();
            kpackage.accept((KmPackageVisitor)new RemappingKmVisitors(this.remapper).new RemappingKmVisitors.RemappingKmPackageVisitor((KmPackageVisitor)writer));
            KotlinClassHeader remapped = writer.write(((KotlinClassMetadata.MultiFileClassPart)metadata).getFacadeClassName(), ((KotlinClassMetadata.MultiFileClassPart)metadata).getHeader().getMetadataVersion(), ((KotlinClassMetadata.MultiFileClassPart)metadata).getHeader().getExtraInt()).getHeader();
            this.writeClassHeader(remapped);
            this.validateKotlinClassHeader(remapped, header);
        } else if ((metadata instanceof KotlinClassMetadata.MultiFileClassFacade ? true : metadata instanceof KotlinClassMetadata.Unknown) ? true : metadata == null) {
            this.accept(this.next);
        }
    }

    private final KotlinClassHeader readHeader() {
        Integer kind = null;
        int[] metadataVersion = null;
        String[] data1 = null;
        String[] data2 = null;
        String extraString = null;
        String packageName = null;
        Integer extraInt = null;
        if (this.values == null) {
            return null;
        }
        List list = this.values;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)list, (int)2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection thisCollection$iv;
            boolean $i$f$toTypedArray;
            Collection $this$toTypedArray$iv;
            List $dstr$name$value = (List)element$iv;
            boolean bl = false;
            Object name = $dstr$name$value.get(0);
            Object value = $dstr$name$value.get(1);
            Object e = name;
            if (Intrinsics.areEqual(e, (Object)"k")) {
                Object e2 = value;
                if (e2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                kind = (int)((Integer)e2);
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"mv")) {
                Object e3 = value;
                if (e3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
                }
                metadataVersion = CollectionsKt.toIntArray((Collection)((List)e3));
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"d1")) {
                Object e4 = value;
                if (e4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                }
                $this$toTypedArray$iv = (List)e4;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new String[0]) != null) continue;
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            if (Intrinsics.areEqual(e, (Object)"d2")) {
                Object e5 = value;
                if (e5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                }
                $this$toTypedArray$iv = (List)e5;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new String[0]) != null) continue;
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            if (Intrinsics.areEqual(e, (Object)"xs")) {
                Object e6 = value;
                if (e6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                extraString = (String)e6;
                continue;
            }
            if (Intrinsics.areEqual(e, (Object)"pn")) {
                Object e7 = value;
                if (e7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                packageName = (String)e7;
                continue;
            }
            if (!Intrinsics.areEqual(e, (Object)"xi")) continue;
            Object e8 = value;
            if (e8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            extraInt = (int)((Integer)e8);
        }
        return new KotlinClassHeader(kind, metadataVersion, data1, data2, extraString, packageName, extraInt);
    }

    private final void writeClassHeader(KotlinClassHeader header) {
        AnnotationNode newNode = new AnnotationNode(this.api, this.desc);
        List list = this.values;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.values");
        newNode.values = CollectionsKt.toMutableList((Collection)list);
        AnnotationNode $this$writeClassHeader_u24lambda_u2d1 = newNode;
        boolean bl = false;
        int n = $this$writeClassHeader_u24lambda_u2d1.values.size() + -1;
        int n2 = 0;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (n2 <= n3) {
            int i;
            do {
                i = n2;
                n2 += 2;
                Object e = $this$writeClassHeader_u24lambda_u2d1.values.get(i);
                if (Intrinsics.areEqual(e, (Object)"k")) {
                    $this$writeClassHeader_u24lambda_u2d1.values.set(i + 1, header.getKind());
                    continue;
                }
                if (Intrinsics.areEqual(e, (Object)"mv")) {
                    $this$writeClassHeader_u24lambda_u2d1.values.set(i + 1, ArraysKt.toList((int[])header.getMetadataVersion()));
                    continue;
                }
                if (Intrinsics.areEqual(e, (Object)"d1")) {
                    $this$writeClassHeader_u24lambda_u2d1.values.set(i + 1, ArraysKt.toList((Object[])header.getData1()));
                    continue;
                }
                if (Intrinsics.areEqual(e, (Object)"d2")) {
                    $this$writeClassHeader_u24lambda_u2d1.values.set(i + 1, ArraysKt.toList((Object[])header.getData2()));
                    continue;
                }
                if (Intrinsics.areEqual(e, (Object)"xs")) {
                    $this$writeClassHeader_u24lambda_u2d1.values.set(i + 1, header.getExtraString());
                    continue;
                }
                if (Intrinsics.areEqual(e, (Object)"pn")) {
                    $this$writeClassHeader_u24lambda_u2d1.values.set(i + 1, header.getPackageName());
                    continue;
                }
                if (!Intrinsics.areEqual(e, (Object)"xi")) continue;
                $this$writeClassHeader_u24lambda_u2d1.values.set(i + 1, header.getExtraInt());
            } while (i != n3);
        }
        newNode.accept(this.next);
    }

    private final void validateKotlinClassHeader(KotlinClassHeader remapped, KotlinClassHeader original) {
        if (remapped.getData2().length != original.getData2().length) {
            this.logger.info("Kotlin class metadata size mismatch: data2 size does not match original in class " + this.className + ". New: " + remapped.getData2().length + " Old: " + original.getData2().length);
        }
    }
}

