/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Inject;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.task.service.JarManifestService;
import net.fabricmc.loom.util.ZipReprocessorUtil;
import net.fabricmc.loom.util.ZipUtils;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.jvm.tasks.Jar;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class AbstractRemapJarTask
extends Jar {
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String MANIFEST_NAMESPACE_KEY = "Fabric-Mapping-Namespace";
    public static final String MANIFEST_SPLIT_ENV_KEY = "Fabric-Loom-Split-Environment";
    public static final String MANIFEST_CLIENT_ENTRIES_KEY = "Fabric-Loom-Client-Only-Entries";
    public static final Attributes.Name MANIFEST_SPLIT_ENV_NAME = new Attributes.Name("Fabric-Loom-Split-Environment");
    public static final Attributes.Name MANIFEST_CLIENT_ENTRIES_NAME = new Attributes.Name("Fabric-Loom-Client-Only-Entries");

    @InputFile
    public abstract RegularFileProperty getInputFile();

    @InputFiles
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    public abstract Property<String> getSourceNamespace();

    @Input
    public abstract Property<String> getTargetNamespace();

    @Input
    public abstract Property<Boolean> getRemapperIsolation();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Input
    public abstract Property<Boolean> getIncludesClientOnlyClasses();

    @Input
    public abstract ListProperty<String> getAdditionalClientOnlyEntries();

    @Inject
    public AbstractRemapJarTask() {
        this.getSourceNamespace().convention((Object)MappingsNamespace.NAMED.toString()).finalizeValueOnRead();
        this.getTargetNamespace().convention((Object)MappingsNamespace.INTERMEDIARY.toString()).finalizeValueOnRead();
        this.getRemapperIsolation().convention((Object)false).finalizeValueOnRead();
        this.getIncludesClientOnlyClasses().convention((Object)false).finalizeValueOnRead();
    }

    public final <P extends AbstractRemapParams> void submitWork(Class<? extends AbstractRemapAction<P>> workAction, Action<P> action) {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(workAction, params -> {
            params.getInputFile().set((Provider)this.getInputFile());
            params.getOutputFile().set(this.getArchiveFile());
            params.getSourceNamespace().set(this.getSourceNamespace());
            params.getTargetNamespace().set(this.getTargetNamespace());
            params.getArchivePreserveFileTimestamps().set((Object)this.isPreserveFileTimestamps());
            params.getArchiveReproducibleFileOrder().set((Object)this.isReproducibleFileOrder());
            params.getJarManifestService().set(JarManifestService.get(this.getProject()));
            if (((Boolean)this.getIncludesClientOnlyClasses().get()).booleanValue()) {
                ArrayList<String> clientOnlyEntries = new ArrayList<String>(this.getClientOnlyEntries());
                clientOnlyEntries.addAll((Collection)this.getAdditionalClientOnlyEntries().get());
                this.applyClientOnlyManifestAttributes((AbstractRemapParams)params, (List<String>)clientOnlyEntries);
                params.getClientOnlyEntries().set(clientOnlyEntries.stream().filter(s -> s.endsWith(".class")).toList());
            }
            action.execute(params);
        });
    }

    @Internal
    protected abstract List<String> getClientOnlyEntries();

    protected void applyClientOnlyManifestAttributes(AbstractRemapParams params, List<String> entries) {
        params.getManifestAttributes().set(Map.of(MANIFEST_SPLIT_ENV_KEY, "true", MANIFEST_CLIENT_ENTRIES_KEY, String.join((CharSequence)";", entries)));
    }

    @Deprecated
    @InputFile
    public RegularFileProperty getInput() {
        return this.getInputFile();
    }

    protected static List<String> getRootPaths(Set<File> files) {
        return files.stream().map(root -> {
            Object rootPath = root.getAbsolutePath().replace("\\", "/");
            if (((String)rootPath).charAt(((String)rootPath).length() - 1) != '/') {
                rootPath = (String)rootPath + "/";
            }
            return rootPath;
        }).toList();
    }

    protected static Function<File, String> relativePath(List<String> rootPaths) {
        return file -> {
            String s = file.getAbsolutePath().replace("\\", "/");
            for (String rootPath : rootPaths) {
                if (!s.startsWith(rootPath)) continue;
                s = s.substring(rootPath.length());
            }
            return s;
        };
    }

    public static interface AbstractRemapParams
    extends WorkParameters {
        public RegularFileProperty getInputFile();

        public RegularFileProperty getOutputFile();

        public Property<String> getSourceNamespace();

        public Property<String> getTargetNamespace();

        public Property<Boolean> getArchivePreserveFileTimestamps();

        public Property<Boolean> getArchiveReproducibleFileOrder();

        public Property<JarManifestService> getJarManifestService();

        public MapProperty<String, String> getManifestAttributes();

        public ListProperty<String> getClientOnlyEntries();
    }

    public static abstract class AbstractRemapAction<T extends AbstractRemapParams>
    implements WorkAction<T> {
        protected final Path inputFile = ((File)((AbstractRemapParams)this.getParameters()).getInputFile().getAsFile().get()).toPath();
        protected final Path outputFile = ((File)((AbstractRemapParams)this.getParameters()).getOutputFile().getAsFile().get()).toPath();

        @Inject
        public AbstractRemapAction() {
        }

        protected void modifyJarManifest() throws IOException {
            int count = ZipUtils.transform(this.outputFile, Map.of(AbstractRemapJarTask.MANIFEST_PATH, bytes -> {
                Manifest manifest = new Manifest(new ByteArrayInputStream((byte[])bytes));
                ((JarManifestService)((AbstractRemapParams)this.getParameters()).getJarManifestService().get()).apply(manifest, (Map)((AbstractRemapParams)this.getParameters()).getManifestAttributes().get());
                manifest.getMainAttributes().putValue(AbstractRemapJarTask.MANIFEST_NAMESPACE_KEY, (String)((AbstractRemapParams)this.getParameters()).getTargetNamespace().get());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                manifest.write(out);
                return out.toByteArray();
            }));
            Preconditions.checkState((count > 0 ? 1 : 0) != 0, (Object)"Did not transform any jar manifest");
        }

        protected void rewriteJar() throws IOException {
            boolean isReproducibleFileOrder = (Boolean)((AbstractRemapParams)this.getParameters()).getArchiveReproducibleFileOrder().get();
            boolean isPreserveFileTimestamps = (Boolean)((AbstractRemapParams)this.getParameters()).getArchivePreserveFileTimestamps().get();
            if (isReproducibleFileOrder || !isPreserveFileTimestamps) {
                ZipReprocessorUtil.reprocessZip(this.outputFile.toFile(), isReproducibleFileOrder, isPreserveFileTimestamps);
            }
        }
    }
}

