/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.ide.RunConfig;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.JavaExec;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRunTask
extends JavaExec {
    private final RunConfig config;
    private final ConfigurableFileCollection classpath = this.getProject().getObjects().fileCollection();

    public AbstractRunTask(Function<Project, RunConfig> configProvider) {
        this.setGroup("fabric");
        this.config = configProvider.apply(this.getProject());
        this.setClasspath(this.config.sourceSet.getRuntimeClasspath().filter(File::exists).filter((Spec)new LibraryFilter()));
        this.args(this.config.programArgs);
        this.getMainClass().set((Object)this.config.mainClass);
    }

    private boolean canUseArgFile() {
        return this.getJavaVersion().isJava9Compatible();
    }

    public void exec() {
        if (this.canUseArgFile()) {
            this.getProject().getLogger().debug("Using arg file for {}", (Object)this.getName());
            super.setClasspath((FileCollection)this.getProject().files(new Object[0]));
        } else {
            this.getProject().getLogger().debug("Using bare classpath for {}", (Object)this.getName());
            super.setClasspath((FileCollection)this.classpath);
        }
        this.setWorkingDir(new File(this.getProject().getProjectDir(), this.config.runDir));
        this.environment(this.config.environmentVariables);
        super.exec();
    }

    public void setWorkingDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        super.setWorkingDir(dir);
    }

    public List<String> getJvmArgs() {
        List superArgs = super.getJvmArgs();
        ArrayList<String> args = new ArrayList<String>();
        if (this.canUseArgFile()) {
            String content = "-classpath\n" + this.classpath.getFiles().stream().map(File::getAbsolutePath).map(AbstractRunTask::quoteArg).collect(Collectors.joining(System.getProperty("path.separator")));
            try {
                Path argsFile = Files.createTempFile("loom-classpath", ".args", new FileAttribute[0]);
                Files.writeString(argsFile, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                args.add("@" + argsFile.toAbsolutePath());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create classpath file", e);
            }
        }
        if (superArgs != null) {
            args.addAll(superArgs);
        }
        args.addAll(this.config.vmArgs);
        return args;
    }

    private static String quoteArg(String arg) {
        String specials = " #'\"\n\r\t\f";
        if (!AbstractRunTask.containsAnyChar(arg, " #'\"\n\r\t\f")) {
            return arg;
        }
        StringBuilder sb = new StringBuilder(arg.length() * 2);
        block8: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '\'': {
                    sb.append('\"').append(c).append('\"');
                    continue block8;
                }
                case '\"': {
                    sb.append("\"\\\"\"");
                    continue block8;
                }
                case '\n': {
                    sb.append("\"\\n\"");
                    continue block8;
                }
                case '\r': {
                    sb.append("\"\\r\"");
                    continue block8;
                }
                case '\t': {
                    sb.append("\"\\t\"");
                    continue block8;
                }
                case '\f': {
                    sb.append("\"\\f\"");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        return chars.length() > value.length() ? AbstractRunTask.containsAnyChar(value, chars, 0, value.length()) : AbstractRunTask.containsAnyChar(chars, value, 0, chars.length());
    }

    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public JavaExec setClasspath(@NotNull FileCollection classpath) {
        this.classpath.setFrom((Iterable)classpath);
        return this;
    }

    @NotNull
    public JavaExec classpath(Object ... paths) {
        this.classpath.from(paths);
        return this;
    }

    @NotNull
    public FileCollection getClasspath() {
        return this.classpath;
    }

    private class LibraryFilter
    implements Spec<File> {
        private List<String> excludedLibraryPaths = null;

        private LibraryFilter() {
        }

        public boolean isSatisfiedBy(File element) {
            if (this.excludedLibraryPaths == null) {
                this.excludedLibraryPaths = AbstractRunTask.this.config.getExcludedLibraryPaths(AbstractRunTask.this.getProject());
            }
            if (this.excludedLibraryPaths.contains(element.getAbsolutePath())) {
                AbstractRunTask.this.getProject().getLogger().debug("Excluding library {} from {} run config", (Object)element.getName(), (Object)AbstractRunTask.this.config.configName);
                return false;
            }
            return true;
        }
    }
}

