/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.fabricmc.loom.api.decompilers.DecompilationMetadata;
import net.fabricmc.loom.api.decompilers.DecompilerOptions;
import net.fabricmc.loom.api.decompilers.LoomDecompiler;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.accesswidener.TransitiveAccessWidenerMappingsProcessor;
import net.fabricmc.loom.configuration.ifaceinject.InterfaceInjectionProcessor;
import net.fabricmc.loom.configuration.processors.ModJavadocProcessor;
import net.fabricmc.loom.decompilers.LineNumberRemapper;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.IOStringConsumer;
import net.fabricmc.loom.util.OperatingSystem;
import net.fabricmc.loom.util.gradle.ThreadedProgressLoggerConsumer;
import net.fabricmc.loom.util.gradle.ThreadedSimpleProgressLogger;
import net.fabricmc.loom.util.gradle.WorkerDaemonClientsManagerHelper;
import net.fabricmc.loom.util.ipc.IPCClient;
import net.fabricmc.loom.util.ipc.IPCServer;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.Tiny2Writer;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
public abstract class GenerateSourcesTask
extends AbstractLoomTask {
    private final DecompilerOptions decompilerOptions;

    @InputFile
    public abstract RegularFileProperty getInputJar();

    @InputFile
    public abstract RegularFileProperty getRuntimeJar();

    @InputFiles
    public abstract ConfigurableFileCollection getClasspath();

    @OutputFile
    public abstract RegularFileProperty getOutputJar();

    @Inject
    public abstract WorkerExecutor getWorkerExecutor();

    @Inject
    public abstract WorkerDaemonClientsManager getWorkerDaemonClientsManager();

    @Inject
    public GenerateSourcesTask(DecompilerOptions decompilerOptions) {
        this.decompilerOptions = decompilerOptions;
        this.getOutputs().upToDateWhen(o -> false);
        this.getClasspath().from(new Object[]{decompilerOptions.getClasspath()}).finalizeValueOnRead();
        this.dependsOn(new Object[]{decompilerOptions.getClasspath().getBuiltBy()});
        this.getOutputJar().fileProvider(this.getProject().provider(() -> this.getMappedJarFileWithSuffix("-sources.jar")));
    }

    @TaskAction
    public void run() throws IOException {
        if (!OperatingSystem.is64Bit()) {
            throw new UnsupportedOperationException("GenSources task requires a 64bit JVM to run due to the memory requirements.");
        }
        if (!OperatingSystem.isUnixDomainSocketsSupported()) {
            this.getProject().getLogger().warn("Decompile worker logging disabled as Unix Domain Sockets is not supported on your operating system.");
            this.doWork(null);
            return;
        }
        Path ipcPath = Files.createTempFile("loom", "ipc", new FileAttribute[0]);
        Files.deleteIfExists(ipcPath);
        try (ThreadedProgressLoggerConsumer loggerConsumer = new ThreadedProgressLoggerConsumer(this.getProject(), this.decompilerOptions.getName(), "Decompiling minecraft sources");
             IPCServer logReceiver = new IPCServer(ipcPath, loggerConsumer);){
            this.doWork(logReceiver);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to shutdown log receiver", e);
        }
        finally {
            Files.deleteIfExists(ipcPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(@Nullable IPCServer ipcServer) {
        String jvmMarkerValue = UUID.randomUUID().toString();
        WorkQueue workQueue = this.createWorkQueue(jvmMarkerValue);
        workQueue.submit(DecompileAction.class, params -> {
            params.getDecompilerOptions().set((Object)this.decompilerOptions.toDto());
            params.getInputJar().set((Provider)this.getInputJar());
            params.getRuntimeJar().set((Provider)this.getRuntimeJar());
            params.getSourcesDestinationJar().set((Provider)this.getOutputJar());
            params.getLinemap().set(this.getMappedJarFileWithSuffix("-sources.lmap"));
            params.getLinemapJar().set(this.getMappedJarFileWithSuffix("-linemapped.jar"));
            params.getMappings().set(this.getMappings().toFile());
            if (ipcServer != null) {
                params.getIPCPath().set(ipcServer.getPath().toFile());
            }
            params.getClassPath().setFrom((Iterable)this.getProject().getConfigurations().getByName("minecraftLibraries"));
        });
        try {
            workQueue.await();
        }
        finally {
            boolean stopped;
            if (ipcServer != null && !(stopped = WorkerDaemonClientsManagerHelper.stopIdleJVM(this.getWorkerDaemonClientsManager(), jvmMarkerValue)) && ipcServer.hasReceivedMessage()) {
                throw new RuntimeException("Failed to stop decompile worker JVM");
            }
        }
    }

    private WorkQueue createWorkQueue(String jvmMarkerValue) {
        if (!this.useProcessIsolation()) {
            return this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getClasspath()}));
        }
        return this.getWorkerExecutor().processIsolation(spec -> {
            spec.forkOptions(forkOptions -> {
                forkOptions.setMaxHeapSize(String.format(Locale.ENGLISH, "%dm", this.decompilerOptions.getMemory().get()));
                forkOptions.systemProperty("fabric.loom.decompile.worker", (Object)jvmMarkerValue);
            });
            spec.getClasspath().from(new Object[]{this.getClasspath()});
        });
    }

    private boolean useProcessIsolation() {
        return !Boolean.getBoolean("fabric.loom.genSources.debug");
    }

    private File getMappedJarFileWithSuffix(String suffix) {
        String path = ((RegularFile)this.getRuntimeJar().get()).getAsFile().getAbsolutePath();
        if (!path.toLowerCase(Locale.ROOT).endsWith(".jar")) {
            throw new RuntimeException("Invalid mapped JAR path: " + path);
        }
        return new File(path.substring(0, path.length() - 4) + suffix);
    }

    private Path getMappings() {
        Path outputMappings;
        ModJavadocProcessor javadocProcessor;
        Path inputMappings = this.getExtension().getMappingsProvider().tinyMappings;
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        try (BufferedReader reader = Files.newBufferedReader(inputMappings, StandardCharsets.UTF_8);){
            MappingReader.read((Reader)reader, (MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)mappingTree, MappingsNamespace.INTERMEDIARY.toString()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read mappings", e);
        }
        ArrayList<MappingsProcessor> mappingsProcessors = new ArrayList<MappingsProcessor>();
        if (((Boolean)this.getExtension().getEnableTransitiveAccessWideners().get()).booleanValue()) {
            mappingsProcessors.add(new TransitiveAccessWidenerMappingsProcessor(this.getProject()));
        }
        if (this.getExtension().getInterfaceInjection().isEnabled()) {
            mappingsProcessors.add(new InterfaceInjectionProcessor(this.getProject()));
        }
        if ((javadocProcessor = ModJavadocProcessor.create(this.getProject())) != null) {
            mappingsProcessors.add(javadocProcessor);
        }
        if (mappingsProcessors.isEmpty()) {
            return inputMappings;
        }
        boolean transformed = false;
        for (MappingsProcessor mappingsProcessor : mappingsProcessors) {
            if (!mappingsProcessor.transform(mappingTree)) continue;
            transformed = true;
        }
        if (!transformed) {
            return inputMappings;
        }
        try {
            outputMappings = Files.createTempFile("loom-transitive-mappings", ".tiny", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp file", e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(outputMappings, StandardCharsets.UTF_8, new OpenOption[0]);){
            Tiny2Writer tiny2Writer = new Tiny2Writer((Writer)writer, false);
            mappingTree.accept((MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)tiny2Writer, MappingsNamespace.NAMED.toString()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write mappings", e);
        }
        return outputMappings;
    }

    private static Constructor<LoomDecompiler> getDecompilerConstructor(String clazz) {
        try {
            return Class.forName(clazz).getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static abstract class DecompileAction
    implements WorkAction<DecompileParams> {
        public void execute() {
            block11: {
                block10: {
                    if (!((DecompileParams)this.getParameters()).getIPCPath().isPresent()) break block10;
                    if (OperatingSystem.isUnixDomainSocketsSupported()) break block11;
                }
                this.doDecompile(System.out::println);
                return;
            }
            Path ipcPath = ((RegularFile)((DecompileParams)this.getParameters()).getIPCPath().get()).getAsFile().toPath();
            try (IPCClient ipcClient = new IPCClient(ipcPath);){
                this.doDecompile(new ThreadedSimpleProgressLogger(ipcClient));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to decompile", e);
            }
        }

        private void doDecompile(IOStringConsumer logger) {
            LoomDecompiler decompiler;
            Path inputJar = ((RegularFile)((DecompileParams)this.getParameters()).getInputJar().get()).getAsFile().toPath();
            Path sourcesDestinationJar = ((RegularFile)((DecompileParams)this.getParameters()).getSourcesDestinationJar().get()).getAsFile().toPath();
            Path linemap = ((RegularFile)((DecompileParams)this.getParameters()).getLinemap().get()).getAsFile().toPath();
            Path linemapJar = ((RegularFile)((DecompileParams)this.getParameters()).getLinemapJar().get()).getAsFile().toPath();
            Path runtimeJar = ((RegularFile)((DecompileParams)this.getParameters()).getRuntimeJar().get()).getAsFile().toPath();
            DecompilerOptions.Dto decompilerOptions = (DecompilerOptions.Dto)((DecompileParams)this.getParameters()).getDecompilerOptions().get();
            try {
                String className = decompilerOptions.className();
                Constructor<LoomDecompiler> decompilerConstructor = GenerateSourcesTask.getDecompilerConstructor(className);
                Objects.requireNonNull(decompilerConstructor, "%s must have a no args constructor".formatted(className));
                decompiler = decompilerConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create decompiler", e);
            }
            DecompilationMetadata metadata = new DecompilationMetadata(decompilerOptions.maxThreads(), ((RegularFile)((DecompileParams)this.getParameters()).getMappings().get()).getAsFile().toPath(), this.getLibraries(), logger, decompilerOptions.options());
            decompiler.decompile(inputJar, sourcesDestinationJar, linemap, metadata);
            try {
                metadata.logger().accept("LOOM_CLOSE_LOGGERS");
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close loggers", e);
            }
            if (Files.exists(linemap, new LinkOption[0])) {
                try {
                    this.remapLineNumbers(metadata.logger(), runtimeJar, linemap, linemapJar);
                    Files.copy(linemapJar, runtimeJar, StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(linemapJar);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to remap line numbers", e);
                }
            }
        }

        private void remapLineNumbers(IOStringConsumer logger, Path oldCompiledJar, Path linemap, Path linemappedJarDestination) throws IOException {
            LineNumberRemapper remapper = new LineNumberRemapper();
            remapper.readMappings(linemap.toFile());
            try (FileSystemUtil.Delegate inFs = FileSystemUtil.getJarFileSystem(oldCompiledJar.toFile(), true);
                 FileSystemUtil.Delegate outFs = FileSystemUtil.getJarFileSystem(linemappedJarDestination.toFile(), true);){
                remapper.process(logger, inFs.get().getPath("/", new String[0]), outFs.get().getPath("/", new String[0]));
            }
        }

        private Collection<Path> getLibraries() {
            return ((DecompileParams)this.getParameters()).getClassPath().getFiles().stream().map(File::toPath).collect(Collectors.toSet());
        }
    }

    public static interface MappingsProcessor {
        public boolean transform(MemoryMappingTree var1);
    }

    public static interface DecompileParams
    extends WorkParameters {
        public Property<DecompilerOptions.Dto> getDecompilerOptions();

        public RegularFileProperty getInputJar();

        public RegularFileProperty getRuntimeJar();

        public RegularFileProperty getSourcesDestinationJar();

        public RegularFileProperty getLinemap();

        public RegularFileProperty getLinemapJar();

        public RegularFileProperty getMappings();

        public RegularFileProperty getIPCPath();

        public ConfigurableFileCollection getClassPath();
    }
}

