/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.common.base.Preconditions;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.task.CleanEclipseRunsTask;
import net.fabricmc.loom.task.DownloadAssetsTask;
import net.fabricmc.loom.task.ExtractNativesTask;
import net.fabricmc.loom.task.GenEclipseRunsTask;
import net.fabricmc.loom.task.GenIdeaProjectTask;
import net.fabricmc.loom.task.GenVsCodeProjectTask;
import net.fabricmc.loom.task.MigrateMappingsTask;
import net.fabricmc.loom.task.RemapTaskConfiguration;
import net.fabricmc.loom.task.RunGameTask;
import net.fabricmc.loom.task.ValidateAccessWidenerTask;
import net.fabricmc.loom.task.launch.GenerateDLIConfigTask;
import net.fabricmc.loom.task.launch.GenerateLog4jConfigTask;
import net.fabricmc.loom.task.launch.GenerateRemapClasspathTask;
import net.fabricmc.loom.util.gradle.GradleUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public final class LoomTasks {
    private LoomTasks() {
    }

    public static void registerTasks(Project project) {
        TaskContainer tasks = project.getTasks();
        tasks.register("migrateMappings", MigrateMappingsTask.class, t -> {
            t.setDescription("Migrates mappings to a new version.");
            t.getOutputs().upToDateWhen(o -> false);
        });
        RemapTaskConfiguration.setupRemap(project);
        tasks.register("generateDLIConfig", GenerateDLIConfigTask.class, t -> {
            t.setDescription("Generate the DevLaunchInjector config file");
            t.mustRunAfter(new Object[]{tasks.named("eclipse")});
            t.mustRunAfter(new Object[]{tasks.named("idea")});
        });
        tasks.register("generateLog4jConfig", GenerateLog4jConfigTask.class, t -> t.setDescription("Generate the log4j config file"));
        tasks.register("generateRemapClasspath", GenerateRemapClasspathTask.class, t -> t.setDescription("Generate the remap classpath file"));
        tasks.register("configureLaunch", task -> {
            task.dependsOn(new Object[]{tasks.named("generateDLIConfig")});
            task.dependsOn(new Object[]{tasks.named("generateLog4jConfig")});
            task.dependsOn(new Object[]{tasks.named("generateRemapClasspath")});
            task.setDescription("Setup the required files to launch Minecraft");
            task.setGroup("fabric");
        });
        TaskProvider validateAccessWidener = tasks.register("validateAccessWidener", ValidateAccessWidenerTask.class, t -> {
            t.setDescription("Validate all the rules in the access widener against the Minecraft jar");
            t.setGroup("verification");
        });
        tasks.named("check").configure(task -> task.dependsOn(new Object[]{validateAccessWidener}));
        LoomTasks.registerIDETasks(tasks);
        LoomTasks.registerRunTasks(tasks, project);
        GradleUtils.afterSuccessfulEvaluation(project, () -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            if (extension.getMinecraftJarConfiguration().get() == MinecraftJarConfiguration.SERVER_ONLY) {
                return;
            }
            MinecraftVersionMeta versionInfo = extension.getMinecraftProvider().getVersionInfo();
            if (versionInfo == null) {
                return;
            }
            LoomTasks.registerClientSetupTasks(project.getTasks(), versionInfo.hasNativesToExtract());
        });
    }

    private static void registerIDETasks(TaskContainer tasks) {
        tasks.register("genIdeaWorkspace", GenIdeaProjectTask.class, t -> {
            t.setDescription("Generates an IntelliJ IDEA workspace from this project.");
            t.dependsOn(new Object[]{"idea", LoomTasks.getIDELaunchConfigureTaskName(t.getProject())});
            t.setGroup("ide");
        });
        tasks.register("genEclipseRuns", GenEclipseRunsTask.class, t -> {
            t.setDescription("Generates Eclipse run configurations for this project.");
            t.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(t.getProject())});
            t.setGroup("ide");
        });
        tasks.register("cleanEclipseRuns", CleanEclipseRunsTask.class, t -> {
            t.setDescription("Removes Eclipse run configurations for this project.");
            t.setGroup("ide");
        });
        tasks.register("vscode", GenVsCodeProjectTask.class, t -> {
            t.setDescription("Generates VSCode launch configurations.");
            t.dependsOn(new Object[]{LoomTasks.getIDELaunchConfigureTaskName(t.getProject())});
            t.setGroup("ide");
        });
    }

    private static void registerRunTasks(TaskContainer tasks, Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        Preconditions.checkArgument((extension.getRunConfigs().size() == 0 ? 1 : 0) != 0, (Object)"Run configurations must not be registered before loom");
        extension.getRunConfigs().whenObjectAdded(config -> {
            String configName = config.getName();
            String taskName = "run" + configName.substring(0, 1).toUpperCase() + configName.substring(1);
            tasks.register(taskName, RunGameTask.class, new Object[]{config}).configure(t -> {
                t.setDescription("Starts the '" + config.getConfigName() + "' run configuration");
                t.dependsOn(new Object[]{config.getEnvironment().equals("client") ? "configureClientLaunch" : "configureLaunch"});
            });
        });
        extension.getRunConfigs().create("client", RunConfigSettings::client);
        extension.getRunConfigs().create("server", RunConfigSettings::server);
        GradleUtils.afterSuccessfulEvaluation(project, () -> {
            String taskName;
            switch ((MinecraftJarConfiguration)((Object)((Object)extension.getMinecraftJarConfiguration().get()))) {
                case SERVER_ONLY: {
                    String string = "client";
                    break;
                }
                case CLIENT_ONLY: {
                    String string = "server";
                    break;
                }
                default: {
                    String string = taskName = null;
                }
            }
            if (taskName == null) {
                return;
            }
            extension.getRunConfigs().removeIf(settings -> settings.getName().equals(taskName));
        });
    }

    private static void registerClientSetupTasks(TaskContainer tasks, boolean extractNatives) {
        tasks.register("downloadAssets", DownloadAssetsTask.class, t -> t.setDescription("Downloads required game assets for Minecraft."));
        if (extractNatives) {
            tasks.register("extractNatives", ExtractNativesTask.class, t -> t.setDescription("Extracts the Minecraft platform specific natives."));
        }
        tasks.register("configureClientLaunch", task -> {
            task.dependsOn(new Object[]{tasks.named("downloadAssets")});
            task.dependsOn(new Object[]{tasks.named("configureLaunch")});
            if (extractNatives) {
                task.dependsOn(new Object[]{tasks.named("extractNatives")});
            }
            task.setDescription("Setup the required files to launch the Minecraft client");
            task.setGroup("fabric");
        });
    }

    public static Provider<Task> getIDELaunchConfigureTaskName(Project project) {
        return project.provider(() -> {
            MinecraftJarConfiguration jarConfiguration = (MinecraftJarConfiguration)((Object)((Object)LoomGradleExtension.get(project).getMinecraftJarConfiguration().get()));
            String name = jarConfiguration == MinecraftJarConfiguration.SERVER_ONLY ? "configureLaunch" : "configureClientLaunch";
            return project.getTasks().getByName(name);
        });
    }
}

