/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.api.mappings.layered.spec.LayeredMappingSpecBuilder;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsDependency;
import net.fabricmc.loom.configuration.providers.mappings.MappingsProviderImpl;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.SourceRemapper;
import net.fabricmc.lorenztiny.TinyMappingsJoiner;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.remapper.MercuryRemapper;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Always rerun this task.")
public abstract class MigrateMappingsTask
extends AbstractLoomTask {
    private Path inputDir = this.getProject().file((Object)"src/main/java").toPath();
    private Path outputDir = this.getProject().file((Object)"remappedSrc").toPath();
    private String mappings;

    public MigrateMappingsTask() {
        this.getCompileClasspath().from(new Object[]{this.getProject().getConfigurations().getByName("compileClasspath")});
    }

    @Option(option="input", description="Java source file directory")
    public void setInputDir(String inputDir) {
        this.inputDir = this.getProject().file((Object)inputDir).toPath();
    }

    @Option(option="output", description="Remapped source output directory")
    public void setOutputDir(String outputDir) {
        this.outputDir = this.getProject().file((Object)outputDir).toPath();
    }

    @Option(option="mappings", description="Target mappings")
    public void setMappings(String mappings) {
        this.mappings = mappings;
    }

    @InputFiles
    public abstract ConfigurableFileCollection getCompileClasspath();

    @TaskAction
    public void doTask() throws Throwable {
        Project project = this.getProject();
        LoomGradleExtension extension = this.getExtension();
        project.getLogger().info(":loading mappings");
        if (!Files.exists(this.inputDir, new LinkOption[0]) || !Files.isDirectory(this.inputDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Could not find input directory: " + this.inputDir.toAbsolutePath());
        }
        Files.createDirectories(this.outputDir, new FileAttribute[0]);
        File mappings = this.loadMappings();
        MappingsProviderImpl mappingsProvider = extension.getMappingsProvider();
        try {
            MemoryMappingTree currentMappings = mappingsProvider.getMappings();
            MemoryMappingTree targetMappings = MigrateMappingsTask.getMappings(mappings);
            MigrateMappingsTask.migrateMappings(project, extension, this.inputDir, this.outputDir, currentMappings, targetMappings);
            project.getLogger().lifecycle(":remapped project written to " + this.outputDir.toAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error while loading mappings", e);
        }
    }

    private File loadMappings() {
        Set files;
        Project project = this.getProject();
        if (this.mappings == null || this.mappings.isEmpty()) {
            throw new IllegalArgumentException("No mappings were specified. Use --mappings=\"\" to specify target mappings");
        }
        try {
            if (this.mappings.startsWith("net.minecraft:mappings:")) {
                if (!this.mappings.endsWith(":" + LoomGradleExtension.get(project).getMinecraftProvider().minecraftVersion())) {
                    throw new UnsupportedOperationException("Migrating Mojang mappings is currently only supported for the specified minecraft version");
                }
                LayeredMappingsDependency dep = (LayeredMappingsDependency)this.getExtension().layered((Action<LayeredMappingSpecBuilder>)((Action)LayeredMappingSpecBuilder::officialMojangMappings));
                files = dep.resolve();
            } else {
                Dependency dependency = project.getDependencies().create((Object)this.mappings);
                files = project.getConfigurations().detachedConfiguration(new Dependency[]{dependency}).resolve();
            }
        }
        catch (IllegalDependencyNotation ignored) {
            project.getLogger().info("Could not locate mappings, presuming V2 Yarn");
            try {
                files = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().module((Object)ImmutableMap.of((Object)"group", (Object)"net.fabricmc", (Object)"name", (Object)"yarn", (Object)"version", (Object)this.mappings, (Object)"classifier", (Object)"v2"))}).resolve();
            }
            catch (GradleException ignored2) {
                project.getLogger().info("Could not locate mappings, presuming V1 Yarn");
                files = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().module((Object)ImmutableMap.of((Object)"group", (Object)"net.fabricmc", (Object)"name", (Object)"yarn", (Object)"version", (Object)this.mappings))}).resolve();
            }
        }
        if (files.isEmpty()) {
            throw new IllegalArgumentException("Mappings could not be found");
        }
        return (File)Iterables.getOnlyElement(files);
    }

    private static MemoryMappingTree getMappings(File mappings) throws IOException {
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(mappings.toPath());){
            MappingReader.read((Path)delegate.fs().getPath("mappings/mappings.tiny", new String[0]), (MappingVisitor)mappingTree);
        }
        return mappingTree;
    }

    private static void migrateMappings(Project project, LoomGradleExtension extension, Path inputDir, Path outputDir, MemoryMappingTree currentMappings, MemoryMappingTree targetMappings) throws IOException {
        project.getLogger().info(":joining mappings");
        MappingSet mappingSet = new TinyMappingsJoiner((MappingTree)currentMappings, MappingsNamespace.NAMED.toString(), (MappingTree)targetMappings, MappingsNamespace.NAMED.toString(), MappingsNamespace.INTERMEDIARY.toString()).read();
        project.getLogger().lifecycle(":remapping");
        Mercury mercury = SourceRemapper.createMercuryWithClassPath(project, false);
        JavaVersion javaVersion = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceCompatibility();
        mercury.setSourceCompatibility(javaVersion.toString());
        for (Path intermediaryJar : extension.getMinecraftJars(MappingsNamespace.INTERMEDIARY)) {
            mercury.getClassPath().add(intermediaryJar);
        }
        for (Path intermediaryJar : extension.getMinecraftJars(MappingsNamespace.NAMED)) {
            mercury.getClassPath().add(intermediaryJar);
        }
        mercury.getProcessors().add(MercuryRemapper.create((MappingSet)mappingSet));
        try {
            mercury.rewrite(inputDir, outputDir);
        }
        catch (Exception e) {
            project.getLogger().warn("Could not remap fully!", (Throwable)e);
        }
        project.getLogger().info(":cleaning file descriptors");
        System.gc();
    }
}

