/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import javax.inject.Inject;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.task.service.SourceRemapperService;
import net.fabricmc.loom.util.service.UnsafeWorkQueueHelper;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemapSourcesJarTask
extends AbstractRemapJarTask {
    @Inject
    public RemapSourcesJarTask() {
        this.getClasspath().from(new Object[]{this.getProject().getConfigurations().getByName("compileClasspath")});
    }

    @TaskAction
    public void run() {
        this.submitWork(RemapSourcesAction.class, params -> params.getSourcesRemapperServiceUuid().set((Object)UnsafeWorkQueueHelper.create(this.getProject(), SourceRemapperService.create(this))));
    }

    @Override
    protected List<String> getClientOnlyEntries() {
        SourceSet clientSourceSet = MinecraftSourceSets.Split.getClientSourceSet(this.getProject());
        return clientSourceSet.getAllSource().getFiles().stream().map(RemapSourcesJarTask.relativePath(RemapSourcesJarTask.getRootPaths(clientSourceSet.getAllSource().getSrcDirs()))).toList();
    }

    public static abstract class RemapSourcesAction
    extends AbstractRemapJarTask.AbstractRemapAction<RemapSourcesParams> {
        private static final Logger LOGGER = LoggerFactory.getLogger(RemapSourcesAction.class);
        private final SourceRemapperService sourceRemapperService = UnsafeWorkQueueHelper.get(((RemapSourcesParams)this.getParameters()).getSourcesRemapperServiceUuid(), SourceRemapperService.class);

        public void execute() {
            try {
                this.sourceRemapperService.remapSourcesJar(this.inputFile, this.outputFile);
                this.modifyJarManifest();
                this.rewriteJar();
            }
            catch (Exception e) {
                try {
                    Files.deleteIfExists(this.outputFile);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to delete output file", (Throwable)ex);
                }
                throw new RuntimeException("Failed to remap sources", e);
            }
        }
    }

    public static interface RemapSourcesParams
    extends AbstractRemapJarTask.AbstractRemapParams {
        public Property<String> getSourcesRemapperServiceUuid();
    }
}

