/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.task.RemapJarTask;
import net.fabricmc.loom.task.RemapSourcesJarTask;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;

public class RemapTaskConfiguration {
    public static final String REMAP_JAR_TASK_NAME = "remapJar";
    public static final String REMAP_SOURCES_JAR_TASK_NAME = "remapSourcesJar";

    public static void setupRemap(Project project) {
        TaskContainer tasks = project.getTasks();
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (RemapTaskConfiguration.getBooleanProperty(project, "fabric.loom.dontRemap")) {
            extension.getUnmappedModCollection().from(new Object[]{project.getTasks().getByName("jar")});
            return;
        }
        RemapJarTask remapJarTask = (RemapJarTask)tasks.create(REMAP_JAR_TASK_NAME, RemapJarTask.class, task -> {
            AbstractArchiveTask jarTask = (AbstractArchiveTask)tasks.named("jar", AbstractArchiveTask.class).get();
            task.dependsOn(new Object[]{jarTask});
            task.setDescription("Remaps the built project jar to intermediary mappings.");
            task.setGroup("fabric");
            project.getArtifacts().add("apiElements", (Object)task);
            project.getArtifacts().add("runtimeElements", (Object)task);
            task.getInputFile().convention(jarTask.getArchiveFile());
            task.dependsOn(new Object[]{tasks.named("jar")});
            task.getIncludesClientOnlyClasses().set(project.provider(extension::areEnvironmentSourceSetsSplit));
        });
        tasks.named("jar", AbstractArchiveTask.class).configure(task -> {
            task.getArchiveClassifier().convention((Object)"dev");
            task.getDestinationDirectory().set(new File(project.getBuildDir(), "devlibs"));
        });
        tasks.named("assemble").configure(task -> task.dependsOn(new Object[]{remapJarTask}));
        RemapTaskConfiguration.trySetupSourceRemapping(project);
        if (RemapTaskConfiguration.getBooleanProperty(project, "fabric.loom.disableRemappedVariants")) {
            return;
        }
        GradleUtils.afterSuccessfulEvaluation(project, () -> {
            for (String configurationName : new String[]{"apiElements", "runtimeElements"}) {
                Configuration configuration = project.getConfigurations().getByName(configurationName);
                Jar jarTask = (Jar)project.getTasks().getByName("jar");
                configuration.getArtifacts().removeIf(artifact -> artifact.getFile().getAbsolutePath().equals(((RegularFile)jarTask.getArchiveFile().get()).getAsFile().getAbsolutePath()) && artifact.getBuildDependencies().getDependencies(null).contains(jarTask));
            }
        });
    }

    private static void trySetupSourceRemapping(Project project) {
        TaskContainer tasks = project.getTasks();
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        String sourcesJarTaskName = SourceSetHelper.getMainSourceSet(project).getSourcesJarTaskName();
        TaskProvider remapSourcesTask = tasks.register(REMAP_SOURCES_JAR_TASK_NAME, RemapSourcesJarTask.class, task -> {
            task.setDescription("Remaps the default sources jar to intermediary mappings.");
            task.setGroup("fabric");
            Task sourcesTask = (Task)project.getTasks().findByName(sourcesJarTaskName);
            if (sourcesTask == null) {
                project.getLogger().info("{} task was not found, not remapping sources", (Object)sourcesJarTaskName);
                task.setEnabled(false);
                return;
            }
            if (!(sourcesTask instanceof Jar)) {
                project.getLogger().info("{} task is not a Jar task, not remapping sources", (Object)sourcesJarTaskName);
                task.setEnabled(false);
                return;
            }
            Jar sourcesJarTask = (Jar)sourcesTask;
            sourcesJarTask.getArchiveClassifier().convention((Object)"dev-sources");
            sourcesJarTask.getDestinationDirectory().set(new File(project.getBuildDir(), "devlibs"));
            task.getArchiveClassifier().convention((Object)"sources");
            task.dependsOn(new Object[]{sourcesJarTask});
            task.getInputFile().convention(sourcesJarTask.getArchiveFile());
            task.getIncludesClientOnlyClasses().set(project.provider(extension::areEnvironmentSourceSetsSplit));
        });
        tasks.named("assemble").configure(task -> task.dependsOn(new Object[]{remapSourcesTask}));
        if (RemapTaskConfiguration.getBooleanProperty(project, "fabric.loom.disableRemappedVariants")) {
            return;
        }
        GradleUtils.afterSuccessfulEvaluation(project, () -> {
            Task sourcesTask = (Task)project.getTasks().findByName(sourcesJarTaskName);
            if (!(sourcesTask instanceof Jar)) {
                return;
            }
            Jar sourcesJarTask = (Jar)sourcesTask;
            if (project.getConfigurations().getNames().contains("sourcesElements")) {
                project.getArtifacts().add("sourcesElements", (Object)remapSourcesTask);
                Configuration configuration = project.getConfigurations().getByName("sourcesElements");
                configuration.getArtifacts().removeIf(a -> a.getFile().equals(((RegularFile)sourcesJarTask.getArchiveFile().get()).getAsFile()));
            } else {
                project.getLogger().warn("Not publishing sources jar as it was not found. Use java.withSourcesJar() to fix.");
            }
        });
    }

    private static boolean getBooleanProperty(Project project, String key) {
        return (Boolean)project.getProviders().gradleProperty(key).map(string -> {
            try {
                return Boolean.parseBoolean(string);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
        }).getOrElse((Object)false);
    }
}

