/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.util.GradleVersion;

public abstract class JarManifestService
implements BuildService<Params> {
    public static synchronized Provider<JarManifestService> get(Project project) {
        return project.getGradle().getSharedServices().registerIfAbsent("LoomJarManifestService:" + project.getName(), JarManifestService.class, spec -> spec.parameters(params -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            Optional<String> tinyRemapperVersion = Optional.ofNullable(TinyRemapper.class.getPackage().getImplementationVersion());
            params.getGradleVersion().set((Object)GradleVersion.current().getVersion());
            params.getLoomVersion().set((Object)LoomGradlePlugin.LOOM_VERSION);
            params.getMCEVersion().set((Object)"0.5.0");
            params.getMinecraftVersion().set((Object)extension.getMinecraftProvider().minecraftVersion());
            params.getTinyRemapperVersion().set((Object)tinyRemapperVersion.orElse("unknown"));
            params.getFabricLoaderVersion().set((Object)JarManifestService.getLoaderVersion(project).orElse("unknown"));
            params.getMixinVersion().set((Object)JarManifestService.getMixinVersion(project).orElse(new MixinVersion("unknown", "unknown")));
        }));
    }

    public void apply(Manifest manifest, Map<String, String> extraValues) {
        if (Boolean.getBoolean("loom.test.reproducible")) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        Params p = (Params)this.getParameters();
        attributes.putValue("Fabric-Gradle-Version", (String)p.getGradleVersion().get());
        attributes.putValue("Fabric-Loom-Version", (String)p.getLoomVersion().get());
        attributes.putValue("Fabric-Mixin-Compile-Extensions-Version", (String)p.getMCEVersion().get());
        attributes.putValue("Fabric-Minecraft-Version", (String)p.getMinecraftVersion().get());
        attributes.putValue("Fabric-Tiny-Remapper-Version", (String)p.getTinyRemapperVersion().get());
        attributes.putValue("Fabric-Loader-Version", (String)p.getFabricLoaderVersion().get());
        if (!attributes.containsKey("Fabric-Mixin-Version")) {
            attributes.putValue("Fabric-Mixin-Version", ((MixinVersion)p.getMixinVersion().get()).version());
            attributes.putValue("Fabric-Mixin-Group", ((MixinVersion)p.getMixinVersion().get()).group());
        }
        for (Map.Entry<String, String> entry : extraValues.entrySet()) {
            attributes.putValue(entry.getKey(), entry.getValue());
        }
    }

    private static Optional<String> getLoaderVersion(Project project) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.getInstallerData() == null) {
            project.getLogger().warn("Could not determine fabric loader version for jar manifest");
            return Optional.empty();
        }
        return Optional.of(extension.getInstallerData().version());
    }

    private static Optional<MixinVersion> getMixinVersion(Project project) {
        Optional<Dependency> dependency = project.getConfigurations().getByName("loaderLibraries").getDependencies().stream().filter(dep -> "sponge-mixin".equals(dep.getName())).findFirst();
        if (dependency.isEmpty()) {
            project.getLogger().warn("Could not determine Mixin version for jar manifest");
        }
        return dependency.map(d -> new MixinVersion(d.getGroup(), d.getVersion()));
    }

    static interface Params
    extends BuildServiceParameters {
        public Property<String> getGradleVersion();

        public Property<String> getLoomVersion();

        public Property<String> getMCEVersion();

        public Property<String> getMinecraftVersion();

        public Property<String> getTinyRemapperVersion();

        public Property<String> getFabricLoaderVersion();

        public Property<MixinVersion> getMixinVersion();
    }

    private record MixinVersion(String group, String version) implements Serializable
    {
    }
}

