/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.util.HashSet;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.mappings.MappingsProviderImpl;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;

public final class MixinMappingsService
implements SharedService {
    private final SharedServiceManager sharedServiceManager;
    private final HashSet<File> mixinMappings = new HashSet();

    private MixinMappingsService(SharedServiceManager sharedServiceManager) {
        this.sharedServiceManager = sharedServiceManager;
    }

    public static File getMixinMappingFile(Project project, SourceSet sourceSet) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        File mixinMapping = new File(extension.getFiles().getProjectBuildCache(), "mixin-map-" + extension.getMappingsProvider().mappingsIdentifier() + "." + sourceSet.getName() + ".tiny");
        MixinMappingsService.getService((SharedServiceManager)SharedServiceManager.get((Project)project), (MappingsProviderImpl)extension.getMappingsProvider()).mixinMappings.add(mixinMapping);
        return mixinMapping;
    }

    static synchronized MixinMappingsService getService(SharedServiceManager sharedServiceManager, MappingsProviderImpl mappingsProvider) {
        return sharedServiceManager.getOrCreateService("MixinMappings-" + mappingsProvider.mappingsIdentifier(), () -> new MixinMappingsService(sharedServiceManager));
    }

    IMappingProvider getMappingProvider(String from, String to) {
        return out -> {
            for (File mixinMapping : this.mixinMappings) {
                if (!mixinMapping.exists()) continue;
                MappingsService service = MappingsService.create(this.sharedServiceManager, mixinMapping.getAbsolutePath(), mixinMapping.toPath(), from, to, false);
                service.getMappingsProvider().load(out);
            }
        };
    }
}

