/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.task.service.MixinMappingsService;
import net.fabricmc.loom.util.kotlin.KotlinClasspath;
import net.fabricmc.loom.util.kotlin.KotlinClasspathService;
import net.fabricmc.loom.util.kotlin.KotlinRemapperClassloader;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.extension.mixin.MixinExtension;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;

public class TinyRemapperService
implements SharedService {
    private TinyRemapper tinyRemapper;
    @Nullable
    private KotlinRemapperClassloader kotlinRemapperClassloader;
    private final Map<String, InputTag> inputTagMap = new HashMap<String, InputTag>();
    private final HashSet<Path> classpath = new HashSet();
    private boolean isRemapping = false;

    public static synchronized TinyRemapperService getOrCreate(AbstractRemapJarTask remapJarTask) {
        Project project = remapJarTask.getProject();
        String to = (String)remapJarTask.getTargetNamespace().get();
        String from = (String)remapJarTask.getSourceNamespace().get();
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        SharedServiceManager sharedServiceManager = SharedServiceManager.get(project);
        boolean legacyMixin = (Boolean)extension.getMixin().getUseLegacyMixinAp().get();
        @Nullable KotlinClasspathService kotlinClasspathService = KotlinClasspathService.getOrCreateIfRequired(project);
        StringJoiner joiner = new StringJoiner(":");
        joiner.add(extension.getMappingsProvider().getBuildServiceName("remapJarService", from, to));
        joiner.add(remapJarTask.getName());
        if (kotlinClasspathService != null) {
            joiner.add("kotlin-" + kotlinClasspathService.version());
        }
        if (((Boolean)remapJarTask.getRemapperIsolation().get()).booleanValue()) {
            joiner.add(project.getPath());
        }
        String id = joiner.toString();
        TinyRemapperService service = sharedServiceManager.getOrCreateService(id, () -> {
            ArrayList<IMappingProvider> mappings = new ArrayList<IMappingProvider>();
            mappings.add(MappingsService.createDefault(project, from, to).getMappingsProvider());
            if (legacyMixin) {
                mappings.add(MixinMappingsService.getService(SharedServiceManager.get(project), extension.getMappingsProvider()).getMappingProvider(from, to));
            }
            return new TinyRemapperService(mappings, !legacyMixin, kotlinClasspathService);
        });
        service.readClasspath(remapJarTask.getClasspath().getFiles().stream().map(File::toPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList());
        return service;
    }

    public TinyRemapperService(List<IMappingProvider> mappings, boolean useMixinExtension, @Nullable KotlinClasspath kotlinClasspath) {
        TinyRemapper.Builder builder = TinyRemapper.newRemapper();
        for (IMappingProvider provider : mappings) {
            builder.withMappings(provider);
        }
        if (useMixinExtension) {
            builder.extension((TinyRemapper.Extension)new MixinExtension());
        }
        if (kotlinClasspath != null) {
            this.kotlinRemapperClassloader = KotlinRemapperClassloader.create(kotlinClasspath);
            builder.extension((TinyRemapper.Extension)this.kotlinRemapperClassloader.getTinyRemapperExtension());
        }
        this.tinyRemapper = builder.build();
    }

    public synchronized InputTag getOrCreateTag(Path file) {
        InputTag tag = this.inputTagMap.get(file.toAbsolutePath().toString());
        if (tag == null) {
            tag = this.tinyRemapper.createInputTag();
            this.inputTagMap.put(file.toAbsolutePath().toString(), tag);
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TinyRemapper getTinyRemapperForRemapping() {
        TinyRemapperService tinyRemapperService = this;
        synchronized (tinyRemapperService) {
            this.isRemapping = true;
            return Objects.requireNonNull(this.tinyRemapper, "Tiny remapper has not been setup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TinyRemapper getTinyRemapperForInputs() {
        TinyRemapperService tinyRemapperService = this;
        synchronized (tinyRemapperService) {
            if (this.isRemapping) {
                throw new IllegalStateException("Cannot read inputs as remapping has already started");
            }
            return this.tinyRemapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readClasspath(List<Path> paths) {
        List<Path> toRead;
        HashSet<Path> hashSet = this.classpath;
        synchronized (hashSet) {
            toRead = paths.stream().filter(path -> !this.classpath.contains(path)).toList();
            this.classpath.addAll(paths);
        }
        this.tinyRemapper.readClassPathAsync((Path[])toRead.toArray(Path[]::new));
    }

    @Override
    public void close() throws IOException {
        if (this.tinyRemapper != null) {
            this.tinyRemapper.finish();
            this.tinyRemapper = null;
        }
        if (this.kotlinRemapperClassloader != null) {
            this.kotlinRemapperClassloader.close();
        }
    }
}

