/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.WarningMode;

public interface DeprecationHelper {
    default public void replaceWithInLoom0_12(String currentName, String newName) {
        this.toBeRemovedIn(currentName, newName, "Loom 0.12");
    }

    default public void toBeRemovedIn(String currentName, String newName, String removalVersion) {
        this.warn("The '%s' property has been deprecated, and has been replaced with '%s'. This is scheduled to be removed in %s.".formatted(currentName, newName, removalVersion));
    }

    public Project getProject();

    public void warn(String var1);

    public static class ProjectBased
    implements DeprecationHelper {
        private final Project project;
        private final AtomicBoolean usingDeprecatedApi = new AtomicBoolean(false);

        public ProjectBased(Project project) {
            this.project = project;
            project.getGradle().buildFinished(buildResult -> {
                if (this.usingDeprecatedApi.get()) {
                    project.getLogger().lifecycle("Deprecated Loom APIs were used in this build, making it incompatible with future versions of Loom. Use Gradle warning modes to control the verbosity of the warnings.");
                }
            });
        }

        @Override
        public Project getProject() {
            return this.project;
        }

        @Override
        public void warn(String warning) {
            WarningMode warningMode = this.getProject().getGradle().getStartParameter().getWarningMode();
            this.getProject().getLogger().log(warningMode == WarningMode.None ? LogLevel.INFO : LogLevel.WARN, warning);
            if (warningMode == WarningMode.Fail) {
                throw new UnsupportedOperationException(warning);
            }
            this.usingDeprecatedApi.set(true);
        }
    }
}

