/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.fabricmc.loom.util.ZipUtils;
import org.jetbrains.annotations.Nullable;

public final class ModUtils {
    private ModUtils() {
    }

    public static boolean isMod(File file) {
        return ModUtils.isMod(file.toPath());
    }

    public static boolean isMod(Path input) {
        return ZipUtils.contains(input, "fabric.mod.json");
    }

    @Nullable
    public static JsonObject getFabricModJson(Path path) {
        try {
            return ZipUtils.unpackGsonNullable(path, "fabric.mod.json", JsonObject.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to extract fabric.mod.json from " + path, e);
        }
    }
}

