/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.StandardProtocolFamily;
import java.nio.channels.ServerSocketChannel;

public class OperatingSystem {
    public static final String WINDOWS = "windows";
    public static final String MAC_OS = "osx";
    public static final String LINUX = "linux";
    public static final String CURRENT_OS = OperatingSystem.getOS();

    private static String getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("mac")) {
            return MAC_OS;
        }
        return LINUX;
    }

    public static boolean is64Bit() {
        return System.getProperty("sun.arch.data.model").contains("64");
    }

    public static boolean isCIBuild() {
        String loomProperty = System.getProperty("fabric.loom.ci");
        if (loomProperty != null) {
            return loomProperty.equalsIgnoreCase("true");
        }
        return System.getenv("CI") != null;
    }

    public static boolean isUnixDomainSocketsSupported() {
        boolean bl;
        block9: {
            ServerSocketChannel serverChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
            try {
                bl = true;
                if (serverChannel == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (serverChannel != null) {
                        try {
                            serverChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedOperationException e) {
                    return false;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            serverChannel.close();
        }
        return bl;
    }
}

