/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.RecordComponentFixVisitor;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Project;

public final class TinyRemapperHelper {
    private static final Map<String, String> JSR_TO_JETBRAINS = new ImmutableMap.Builder().put((Object)"javax/annotation/Nullable", (Object)"org/jetbrains/annotations/Nullable").put((Object)"javax/annotation/Nonnull", (Object)"org/jetbrains/annotations/NotNull").put((Object)"javax/annotation/concurrent/Immutable", (Object)"org/jetbrains/annotations/Unmodifiable").build();
    private static final Pattern MC_LV_PATTERN = Pattern.compile("\\$\\$\\d+");

    private TinyRemapperHelper() {
    }

    public static TinyRemapper getTinyRemapper(Project project, String fromM, String toM) throws IOException {
        return TinyRemapperHelper.getTinyRemapper(project, fromM, toM, false, builder -> {});
    }

    public static TinyRemapper getTinyRemapper(Project project, String fromM, String toM, boolean fixRecords, Consumer<TinyRemapper.Builder> builderConsumer) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        MemoryMappingTree mappingTree = extension.getMappingsProvider().getMappings();
        if (fixRecords && !mappingTree.getSrcNamespace().equals(fromM)) {
            throw new IllegalStateException("Mappings src namespace must match remap src namespace");
        }
        int intermediaryNsId = mappingTree.getNamespaceId(MappingsNamespace.INTERMEDIARY.toString());
        TinyRemapper.Builder builder = TinyRemapper.newRemapper().withMappings(TinyRemapperHelper.create((MappingTree)mappingTree, fromM, toM, true)).withMappings(out -> JSR_TO_JETBRAINS.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptClass(arg_0, arg_1))).renameInvalidLocals(true).rebuildSourceFilenames(true).invalidLvNamePattern(MC_LV_PATTERN).inferNameFromSameLvIndex(true).extraPreApplyVisitor((cls, next) -> {
            if (fixRecords && !cls.isRecord() && "java/lang/Record".equals(cls.getSuperName())) {
                return new RecordComponentFixVisitor(next, mappingTree, intermediaryNsId);
            }
            return next;
        });
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Path[] getMinecraftDependencies(Project project) {
        return (Path[])project.getConfigurations().getByName("minecraftLibraries").getFiles().stream().map(File::toPath).toArray(Path[]::new);
    }

    private static IMappingProvider.Member memberOf(String className, String memberName, String descriptor) {
        return new IMappingProvider.Member(className, memberName, descriptor);
    }

    public static IMappingProvider create(Path mappings, String from, String to, boolean remapLocalVariables) throws IOException {
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        MappingReader.read((Path)mappings, (MappingVisitor)mappingTree);
        return TinyRemapperHelper.create((MappingTree)mappingTree, from, to, remapLocalVariables);
    }

    public static IMappingProvider create(MappingTree mappings, String from, String to, boolean remapLocalVariables) {
        return acceptor -> {
            int fromId = mappings.getNamespaceId(from);
            int toId = mappings.getNamespaceId(to);
            for (MappingTree.ClassMapping classDef : mappings.getClasses()) {
                String className = classDef.getName(fromId);
                String dstName = classDef.getName(toId);
                if (dstName == null) {
                    dstName = className;
                }
                acceptor.acceptClass(className, dstName);
                for (MappingTree.FieldMapping field : classDef.getFields()) {
                    acceptor.acceptField(TinyRemapperHelper.memberOf(className, field.getName(fromId), field.getDesc(fromId)), field.getName(toId));
                }
                for (MappingTree.MethodMapping method : classDef.getMethods()) {
                    IMappingProvider.Member methodIdentifier = TinyRemapperHelper.memberOf(className, method.getName(fromId), method.getDesc(fromId));
                    acceptor.acceptMethod(methodIdentifier, method.getName(toId));
                    if (!remapLocalVariables) continue;
                    for (MappingTree.MethodArgMapping parameter : method.getArgs()) {
                        String name = parameter.getName(toId);
                        if (name == null) continue;
                        acceptor.acceptMethodArg(methodIdentifier, parameter.getLvIndex(), name);
                    }
                    for (MappingTree.MethodVarMapping localVariable : method.getVars()) {
                        acceptor.acceptMethodVar(methodIdentifier, localVariable.getLvIndex(), localVariable.getStartOpIdx(), localVariable.getLvtRowIndex(), localVariable.getName(toId));
                    }
                }
            }
        };
    }
}

