/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipReprocessorUtil {
    private static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();

    private ZipReprocessorUtil() {
    }

    public static void reprocessZip(File file, boolean reproducibleFileOrder, boolean preserveFileTimestamps) throws IOException {
        if (!reproducibleFileOrder && preserveFileTimestamps) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry[] entries = reproducibleFileOrder ? (ZipEntry[])zipFile.stream().sorted(Comparator.comparing(ZipEntry::getName)).toArray(ZipEntry[]::new) : (ZipEntry[])zipFile.stream().toArray(ZipEntry[]::new);
            ByteArrayOutputStream outZip = new ByteArrayOutputStream(zipFile.size());
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(outZip);){
                ZipEntry[] zipEntryArray = entries;
                int n = zipEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    int length;
                    ZipEntry entry;
                    ZipEntry newEntry = entry = zipEntryArray[i];
                    if (!preserveFileTimestamps) {
                        newEntry = new ZipEntry(entry.getName());
                        newEntry.setTime(CONSTANT_TIME_FOR_ZIP_ENTRIES);
                        newEntry.setLastModifiedTime(FileTime.fromMillis(CONSTANT_TIME_FOR_ZIP_ENTRIES));
                        newEntry.setLastAccessTime(FileTime.fromMillis(CONSTANT_TIME_FOR_ZIP_ENTRIES));
                    }
                    zipOutputStream.putNextEntry(newEntry);
                    InputStream inputStream = zipFile.getInputStream(entry);
                    byte[] buf = new byte[1024];
                    while ((length = inputStream.read(buf)) > 0) {
                        zipOutputStream.write(buf, 0, length);
                    }
                    zipOutputStream.closeEntry();
                }
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                outZip.writeTo(fileOutputStream);
            }
        }
    }
}

