/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.download;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Locale;
import net.fabricmc.loom.util.download.Download;
import net.fabricmc.loom.util.download.DownloadException;
import net.fabricmc.loom.util.download.DownloadExecutor;
import net.fabricmc.loom.util.download.DownloadProgressListener;

public class DownloadBuilder {
    private static final Duration ONE_DAY = Duration.ofDays(1L);
    private final URI url;
    private String expectedHash = null;
    private boolean useEtag = true;
    private boolean forceDownload = false;
    private boolean offline = false;
    private Duration maxAge = Duration.ZERO;
    private DownloadProgressListener progressListener = DownloadProgressListener.NONE;
    private int maxRetries = 3;

    private DownloadBuilder(URI url) {
        this.url = url;
    }

    static DownloadBuilder create(String url) throws URISyntaxException {
        return new DownloadBuilder(new URI(url));
    }

    public DownloadBuilder sha1(String sha1) {
        this.expectedHash = "sha1:" + sha1;
        return this;
    }

    public DownloadBuilder etag(boolean useEtag) {
        this.useEtag = useEtag;
        return this;
    }

    public DownloadBuilder forceDownload() {
        this.forceDownload = true;
        return this;
    }

    public DownloadBuilder offline() {
        this.offline = true;
        return this;
    }

    public DownloadBuilder maxAge(Duration duration) {
        this.maxAge = duration;
        return this;
    }

    public DownloadBuilder progress(DownloadProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public DownloadBuilder maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public DownloadBuilder defaultCache() {
        this.etag(true);
        return this.maxAge(ONE_DAY);
    }

    private Download build() {
        return new Download(this.url, this.expectedHash, this.useEtag, this.forceDownload, this.offline, this.maxAge, this.progressListener);
    }

    public void downloadPathAsync(Path path, DownloadExecutor executor) {
        executor.runAsync(() -> this.downloadPath(path));
    }

    public void downloadPath(Path path) throws DownloadException {
        this.withRetries(() -> {
            this.build().downloadPath(path);
            return null;
        });
    }

    public String downloadString() throws DownloadException {
        return this.withRetries(() -> this.build().downloadString());
    }

    public String downloadString(Path cache) throws DownloadException {
        return this.withRetries(() -> {
            this.build().downloadPath(cache);
            try {
                return Files.readString(cache, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                try {
                    Files.deleteIfExists(cache);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DownloadException("Failed to download and read string", e);
            }
        });
    }

    private <T> T withRetries(DownloadSupplier<T> supplier) throws DownloadException {
        for (int i = 1; i <= this.maxRetries; ++i) {
            try {
                return supplier.get();
            }
            catch (DownloadException e) {
                if (i != this.maxRetries) continue;
                throw new DownloadException(String.format(Locale.ENGLISH, "Failed download after %d attempts", this.maxRetries), e);
            }
        }
        throw new IllegalStateException();
    }

    @FunctionalInterface
    private static interface DownloadSupplier<T> {
        public T get() throws DownloadException;
    }
}

