/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.kotlin;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loom.util.kotlin.KotlinClasspath;
import net.fabricmc.loom.util.kotlin.KotlinPluginUtils;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.jetbrains.annotations.Nullable;

public record KotlinClasspathService(Set<URL> classpath, String version) implements KotlinClasspath,
SharedService
{
    @Nullable
    public static KotlinClasspathService getOrCreateIfRequired(Project project) {
        if (!KotlinPluginUtils.hasKotlinPlugin(project)) {
            return null;
        }
        return KotlinClasspathService.getOrCreate(project, KotlinPluginUtils.getKotlinPluginVersion(project), KotlinPluginUtils.getKotlinMetadataVersion());
    }

    public static synchronized KotlinClasspathService getOrCreate(Project project, String kotlinVersion, String kotlinMetadataVersion) {
        String id = "kotlinclasspath:%s:%s".formatted(kotlinVersion, kotlinMetadataVersion);
        SharedServiceManager sharedServiceManager = SharedServiceManager.get(project);
        return sharedServiceManager.getOrCreateService(id, () -> KotlinClasspathService.create(project, kotlinVersion, kotlinMetadataVersion));
    }

    private static KotlinClasspathService create(Project project, String kotlinVersion, String kotlinMetadataVersion) {
        Configuration detachedConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-stdlib:" + kotlinVersion)), project.getDependencies().create((Object)("org.jetbrains.kotlinx:kotlinx-metadata-jvm:" + kotlinMetadataVersion))});
        Set<URL> classpath = detachedConfiguration.getFiles().stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toSet());
        return new KotlinClasspathService(classpath, kotlinVersion);
    }
}

