/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.kotlin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.gradle.api.Project;

public class KotlinPluginUtils {
    private static final String KOTLIN_PLUGIN_ID = "org.jetbrains.kotlin.jvm";
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\((.*?)\\)");

    public static boolean hasKotlinPlugin(Project project) {
        return project.getPluginManager().hasPlugin(KOTLIN_PLUGIN_ID);
    }

    public static String getKotlinPluginVersion(Project project) {
        Class<?> kotlinPluginClass = project.getPlugins().getPlugin(KOTLIN_PLUGIN_ID).getClass();
        String implVersion = kotlinPluginClass.getPackage().getImplementationVersion();
        Matcher matcher = VERSION_PATTERN.matcher(implVersion);
        if (!matcher.find()) {
            throw new IllegalStateException("Unable to match Kotlin version from: " + implVersion);
        }
        return matcher.group(1);
    }

    public static String getKotlinMetadataVersion() {
        return KotlinClassMetadata.class.getPackage().getImplementationVersion();
    }
}

