/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.fabricmc.loom.util.service.SharedService;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;

public final class SharedServiceManager {
    private static final Map<Gradle, SharedServiceManager> SERVICE_FACTORY_MAP = new ConcurrentHashMap<Gradle, SharedServiceManager>();
    private final Gradle gradle;
    private final Map<String, SharedService> sharedServiceMap = new ConcurrentHashMap<String, SharedService>();
    private boolean shutdown = false;

    private SharedServiceManager(Gradle gradle) {
        this.gradle = gradle;
        this.gradle.buildFinished(this::onFinish);
    }

    public static SharedServiceManager get(Project project) {
        return SharedServiceManager.get(project.getGradle());
    }

    public static SharedServiceManager get(Gradle gradle) {
        return SERVICE_FACTORY_MAP.computeIfAbsent(gradle, SharedServiceManager::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends SharedService> S getOrCreateService(String id, Supplier<S> function) {
        Map<String, SharedService> map = this.sharedServiceMap;
        synchronized (map) {
            if (this.shutdown) {
                throw new UnsupportedOperationException("Cannot get or create service has the manager has been shutdown.");
            }
            SharedService sharedService = this.sharedServiceMap.get(id);
            if (sharedService == null) {
                sharedService = (SharedService)function.get();
                this.sharedServiceMap.put(id, sharedService);
            }
            return (S)sharedService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinish(BuildResult buildResult) {
        Map<String, SharedService> map = this.sharedServiceMap;
        synchronized (map) {
            this.shutdown = true;
        }
        SERVICE_FACTORY_MAP.remove(this.gradle);
        ArrayList<IOException> exceptionList = new ArrayList<IOException>();
        for (SharedService sharedService : this.sharedServiceMap.values()) {
            try {
                sharedService.close();
            }
            catch (IOException e) {
                exceptionList.add(e);
            }
        }
        this.sharedServiceMap.clear();
        if (!exceptionList.isEmpty()) {
            RuntimeException exception = new RuntimeException("Failed to close all shared services");
            exceptionList.forEach(exception::addSuppressed);
            throw exception;
        }
        System.gc();
    }
}

