/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.service;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loom.util.service.SharedService;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;

public final class UnsafeWorkQueueHelper {
    private static final Map<String, SharedService> SERVICE_MAP = new ConcurrentHashMap<String, SharedService>();

    private UnsafeWorkQueueHelper() {
    }

    public static String create(Project project, SharedService service) {
        String uuid = UUID.randomUUID().toString();
        SERVICE_MAP.put(uuid, service);
        project.getGradle().buildFinished(buildResult -> SERVICE_MAP.remove(uuid));
        return uuid;
    }

    public static <S> S get(Property<String> property, Class<S> clazz) {
        SharedService service = SERVICE_MAP.remove(property.get());
        if (service == null) {
            throw new NullPointerException("Failed to get service for " + clazz);
        }
        return (S)service;
    }
}

