/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.accesswidener;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerRemapper;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.accesswidener.TransitiveOnlyFilter;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerEntry;
import net.fabricmc.loom.util.LazyCloseable;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.ModEnvironment;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.commons.Remapper;

public record ModAccessWidenerEntry(FabricModJson mod, String path, ModEnvironment environment, boolean transitiveOnly) implements AccessWidenerEntry
{
    public static List<ModAccessWidenerEntry> readAll(FabricModJson modJson, boolean transitiveOnly) {
        ArrayList<ModAccessWidenerEntry> entries = new ArrayList<ModAccessWidenerEntry>();
        for (Map.Entry<String, ModEnvironment> entry : modJson.getClassTweakers().entrySet()) {
            entries.add(new ModAccessWidenerEntry(modJson, entry.getKey(), entry.getValue(), transitiveOnly));
        }
        return Collections.unmodifiableList(entries);
    }

    @Override
    @Nullable
    public String mappingId() {
        return this.transitiveOnly ? this.mod.getId() : null;
    }

    @Override
    public String getSortKey() {
        return this.mod.getId() + ":" + this.path;
    }

    @Override
    public void read(AccessWidenerVisitor visitor, LazyCloseable<TinyRemapper> remapper) throws IOException {
        byte[] data;
        AccessWidenerReader.Header header;
        if (this.transitiveOnly) {
            visitor = new TransitiveOnlyFilter(visitor);
        }
        if (!(header = AccessWidenerReader.readHeader((byte[])(data = this.readRaw()))).getNamespace().equals(MappingsNamespace.NAMED.toString())) {
            visitor = ModAccessWidenerEntry.getRemapper(visitor, remapper.get());
        }
        AccessWidenerReader reader = new AccessWidenerReader(visitor);
        reader.read(data);
    }

    private static AccessWidenerRemapper getRemapper(AccessWidenerVisitor visitor, TinyRemapper tinyRemapper) {
        return new AccessWidenerRemapper(visitor, (Remapper)tinyRemapper.getEnvironment().getRemapper(), MappingsNamespace.INTERMEDIARY.toString(), MappingsNamespace.NAMED.toString());
    }

    private byte[] readRaw() throws IOException {
        return this.mod.getSource().read(this.path);
    }
}

