/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods.dependency.refmap;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loom.configuration.mods.dependency.refmap.MixinReferenceRemapper;
import net.fabricmc.loom.util.fmj.mixin.MixinRefmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record MixinReferenceRemapperImpl(Map<String, MixinRefmap.ReferenceMappingData> data) implements MixinReferenceRemapper
{
    private static final Logger LOGGER = LoggerFactory.getLogger(MixinReferenceRemapperImpl.class);

    public static MixinReferenceRemapper createFromRefmaps(String from, String to, Stream<MixinRefmap> refmaps) {
        MixinRefmap.NamespacePair namespaces = new MixinRefmap.NamespacePair(from, to);
        Map<String, MixinRefmap.ReferenceMappingData> data = refmaps.map(refmap -> refmap.getData(namespaces)).filter(Objects::nonNull).map(MixinRefmap.MixinMappingData::data).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> {
            LOGGER.warn("Duplicate mixin reference mapping for {} in refmaps, using the first one", existing);
            return existing;
        }));
        return new MixinReferenceRemapperImpl(data);
    }

    @Override
    public String remapReference(String mixinClassName, String reference) {
        MixinRefmap.ReferenceMappingData data = this.data().get(mixinClassName);
        if (data != null) {
            return data.remap(reference);
        }
        return reference;
    }
}

