/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.processors;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import net.fabricmc.loom.api.processor.MinecraftJarProcessor;
import net.fabricmc.loom.api.processor.ProcessorContext;
import net.fabricmc.loom.api.processor.SpecContext;
import net.fabricmc.loom.util.TinyRemapperLoggerAdapter;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrLogger;
import org.jspecify.annotations.Nullable;

public class JsrAnnotationRemapperProcessor
implements MinecraftJarProcessor<Spec> {
    private static final Map<String, String> JETBRAINS_TO_JSR = Map.of("org/jetbrains/annotations/Nullable", "javax/annotation/Nullable", "org/jetbrains/annotations/NotNull", "javax/annotation/Nonnull", "org/jetbrains/annotations/Unmodifiable", "javax/annotation/concurrent/Immutable");
    private final String name;

    @Inject
    public JsrAnnotationRemapperProcessor(String name) {
        this.name = name;
    }

    @Override
    public @Nullable Spec buildSpec(SpecContext context) {
        return new Spec(JETBRAINS_TO_JSR);
    }

    @Override
    public void processJar(Path jar, Spec spec, ProcessorContext context) throws IOException {
        TinyRemapper tinyRemapper = TinyRemapper.newRemapper((TrLogger)TinyRemapperLoggerAdapter.INSTANCE).withMappings(spec.getMappings()).build();
        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(jar).build();){
            tinyRemapper.readInputs(new Path[]{jar});
            tinyRemapper.apply((BiConsumer)outputConsumer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to remap JAR " + String.valueOf(jar) + " with mapping " + String.valueOf(spec.annotationMapping()), e);
        }
        finally {
            tinyRemapper.finish();
        }
    }

    public String getName() {
        return this.name;
    }

    public record Spec(Map<String, String> annotationMapping) implements MinecraftJarProcessor.Spec
    {
        public IMappingProvider getMappings() {
            return out -> this.annotationMapping.forEach((arg_0, arg_1) -> ((IMappingProvider.MappingAcceptor)out).acceptClass(arg_0, arg_1));
        }
    }
}

