/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.ide.idea;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

record DownloadSourcesHook(Project project, Task task) {
    public static final String INIT_SCRIPT_NAME = "ijDownloadSources";
    private static final Pattern NOTATION_PATTERN = Pattern.compile("dependencyNotation = '(?<notation>.*)'");
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadSourcesHook.class);

    public static boolean hasInitScript(Project project) {
        List initScripts = project.getGradle().getStartParameter().getInitScripts();
        for (File initScript : initScripts) {
            if (!initScript.getName().contains(INIT_SCRIPT_NAME)) continue;
            return true;
        }
        return false;
    }

    void tryHook() {
        List initScripts = this.project.getGradle().getStartParameter().getInitScripts();
        for (File initScript : initScripts) {
            if (!initScript.getName().contains(INIT_SCRIPT_NAME)) continue;
            try {
                String script = Files.readString(initScript.toPath(), StandardCharsets.UTF_8);
                String notation = this.parseInitScript(script);
                if (notation == null) {
                    LOGGER.debug("failed to parse init script dependency");
                    continue;
                }
                MinecraftJar.Type jarType = this.getJarType(notation);
                if (jarType == null) {
                    LOGGER.debug("init script is trying to download sources for another Minecraft jar ({}) not used by this project ({})", (Object)notation, (Object)this.project.getPath());
                    continue;
                }
                String sourcesTaskName = this.getGenSourcesTaskName(jarType);
                this.task.dependsOn(new Object[]{this.project.getTasks().named(sourcesTaskName)});
                LOGGER.info("Running genSources task: {} in project: {} for {}", new Object[]{sourcesTaskName, this.project.getPath(), notation});
                break;
            }
            catch (IOException iOException) {
            }
        }
    }

    @Nullable
    private String parseInitScript(String script) {
        if (!script.contains("IjDownloadTask")) {
            return null;
        }
        Matcher matcher = NOTATION_PATTERN.matcher(script);
        if (matcher.find()) {
            return matcher.group("notation");
        }
        return null;
    }

    private String getGenSourcesTaskName(MinecraftJar.Type jarType) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        return ((MinecraftJarConfiguration)((Object)extension.getMinecraftJarConfiguration().get())).getDecompileConfigurationBiFunction().apply(this.project, extension.getNamedMinecraftProvider()).getTaskName(jarType);
    }

    @Nullable
    private MinecraftJar.Type getJarType(String name) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        NamedMinecraftProvider<?> minecraftProvider = extension.getNamedMinecraftProvider();
        List<MinecraftJar.Type> dependencyTypes = minecraftProvider.getDependencyTypes();
        if (dependencyTypes.isEmpty()) {
            throw new IllegalStateException();
        }
        for (MinecraftJar.Type type : dependencyTypes) {
            LocalMavenHelper mavenHelper = minecraftProvider.getMavenHelper(type).withClassifier("sources");
            if (!mavenHelper.getNotation().equals(name)) continue;
            return type;
        }
        return null;
    }
}

