/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.decompile.DecompileConfiguration;
import net.fabricmc.loom.configuration.decompile.SingleJarDecompileConfiguration;
import net.fabricmc.loom.configuration.decompile.SplitDecompileConfiguration;
import net.fabricmc.loom.configuration.processors.MinecraftJarProcessorManager;
import net.fabricmc.loom.configuration.providers.minecraft.MergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SplitMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.IntermediaryMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.ProcessedNamedMinecraftProvider;
import org.gradle.api.Project;

public enum MinecraftJarConfiguration {
    MERGED(MergedMinecraftProvider::new, IntermediaryMinecraftProvider.MergedImpl::new, NamedMinecraftProvider.MergedImpl::new, ProcessedNamedMinecraftProvider.MergedImpl::new, SingleJarDecompileConfiguration::new, List.of("client", "server")),
    SERVER_ONLY(SingleJarMinecraftProvider::server, IntermediaryMinecraftProvider.SingleJarImpl::server, NamedMinecraftProvider.SingleJarImpl::server, ProcessedNamedMinecraftProvider.SingleJarImpl::server, SingleJarDecompileConfiguration::new, List.of("server")),
    CLIENT_ONLY(SingleJarMinecraftProvider::client, IntermediaryMinecraftProvider.SingleJarImpl::client, NamedMinecraftProvider.SingleJarImpl::client, ProcessedNamedMinecraftProvider.SingleJarImpl::client, SingleJarDecompileConfiguration::new, List.of("client")),
    SPLIT(SplitMinecraftProvider::new, IntermediaryMinecraftProvider.SplitImpl::new, NamedMinecraftProvider.SplitImpl::new, ProcessedNamedMinecraftProvider.SplitImpl::new, SplitDecompileConfiguration::new, List.of("client", "server"));

    private final Function<ConfigContext, MinecraftProvider> minecraftProviderFunction;
    private final BiFunction<Project, MinecraftProvider, IntermediaryMinecraftProvider<?>> intermediaryMinecraftProviderBiFunction;
    private final BiFunction<Project, MinecraftProvider, NamedMinecraftProvider<?>> namedMinecraftProviderBiFunction;
    private final BiFunction<NamedMinecraftProvider<?>, MinecraftJarProcessorManager, ProcessedNamedMinecraftProvider<?, ?>> processedNamedMinecraftProviderBiFunction;
    private final BiFunction<Project, MappedMinecraftProvider, DecompileConfiguration<?>> decompileConfigurationBiFunction;
    private final List<String> supportedEnvironments;

    private <M extends MinecraftProvider, P extends NamedMinecraftProvider<M>, Q extends MappedMinecraftProvider> MinecraftJarConfiguration(Function<ConfigContext, M> minecraftProviderFunction, BiFunction<Project, M, IntermediaryMinecraftProvider<M>> intermediaryMinecraftProviderBiFunction, BiFunction<Project, M, P> namedMinecraftProviderBiFunction, BiFunction<P, MinecraftJarProcessorManager, ProcessedNamedMinecraftProvider<M, P>> processedNamedMinecraftProviderBiFunction, BiFunction<Project, Q, DecompileConfiguration<?>> decompileConfigurationBiFunction, List<String> supportedEnvironments) {
        this.minecraftProviderFunction = minecraftProviderFunction;
        this.intermediaryMinecraftProviderBiFunction = intermediaryMinecraftProviderBiFunction;
        this.namedMinecraftProviderBiFunction = namedMinecraftProviderBiFunction;
        this.processedNamedMinecraftProviderBiFunction = processedNamedMinecraftProviderBiFunction;
        this.decompileConfigurationBiFunction = decompileConfigurationBiFunction;
        this.supportedEnvironments = supportedEnvironments;
    }

    public Function<ConfigContext, MinecraftProvider> getMinecraftProviderFunction() {
        return this.minecraftProviderFunction;
    }

    public BiFunction<Project, MinecraftProvider, IntermediaryMinecraftProvider<?>> getIntermediaryMinecraftProviderBiFunction() {
        return this.intermediaryMinecraftProviderBiFunction;
    }

    public BiFunction<Project, MinecraftProvider, NamedMinecraftProvider<?>> getNamedMinecraftProviderBiFunction() {
        return this.namedMinecraftProviderBiFunction;
    }

    public BiFunction<NamedMinecraftProvider<?>, MinecraftJarProcessorManager, ProcessedNamedMinecraftProvider<?, ?>> getProcessedNamedMinecraftProviderBiFunction() {
        return this.processedNamedMinecraftProviderBiFunction;
    }

    public BiFunction<Project, MappedMinecraftProvider, DecompileConfiguration<?>> getDecompileConfigurationBiFunction() {
        return this.decompileConfigurationBiFunction;
    }

    public List<String> getSupportedEnvironments() {
        return this.supportedEnvironments;
    }
}

