/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.library.Library;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryContext;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessorManager;
import net.fabricmc.loom.configuration.providers.minecraft.library.MinecraftLibraryHelper;
import net.fabricmc.loom.configuration.providers.minecraft.library.processors.RuntimeLog4jLibraryProcessor;
import net.fabricmc.loom.util.Platform;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.provider.Provider;

public class MinecraftLibraryProvider {
    private static final Platform platform = Platform.CURRENT;
    private final Project project;
    private final MinecraftProvider minecraftProvider;
    private final LibraryProcessorManager processorManager;

    public MinecraftLibraryProvider(MinecraftProvider minecraftProvider, Project project) {
        this.project = project;
        this.minecraftProvider = minecraftProvider;
        this.processorManager = new LibraryProcessorManager(platform, project.getRepositories(), (List)LoomGradleExtension.get(project).getLibraryProcessors().get(), this.getEnabledProcessors());
    }

    private List<String> getEnabledProcessors() {
        Provider libraryProcessorsProperty;
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        ArrayList<String> enabledProcessors = new ArrayList<String>();
        if (((Boolean)extension.getRuntimeOnlyLog4j().get()).booleanValue()) {
            enabledProcessors.add(RuntimeLog4jLibraryProcessor.class.getSimpleName());
        }
        if ((libraryProcessorsProperty = this.project.getProviders().gradleProperty("fabric.loom.libraryProcessors")).isPresent()) {
            String[] split = ((String)libraryProcessorsProperty.get()).split(":");
            enabledProcessors.addAll(Arrays.asList(split));
        }
        return Collections.unmodifiableList(enabledProcessors);
    }

    public void provide() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        MinecraftJarConfiguration jarConfiguration = (MinecraftJarConfiguration)((Object)extension.getMinecraftJarConfiguration().get());
        boolean provideClient = jarConfiguration.getSupportedEnvironments().contains("client");
        boolean provideServer = jarConfiguration.getSupportedEnvironments().contains("server");
        assert (provideClient || provideServer);
        if (provideClient) {
            this.provideClientLibraries();
        }
        if (provideServer) {
            this.provideServerLibraries();
        }
    }

    private void provideClientLibraries() {
        List<Library> libraries = MinecraftLibraryHelper.getLibrariesForPlatform(this.minecraftProvider.getVersionInfo(), platform);
        List<Library> processLibraries = this.processLibraries(libraries);
        processLibraries.forEach(this::applyClientLibrary);
        if (!this.minecraftProvider.getVersionInfo().hasNativesToExtract()) {
            this.project.getConfigurations().named("minecraftRuntimeLibraries", configuration -> configuration.extendsFrom(new Configuration[]{this.project.getConfigurations().getByName("minecraftNatives")}));
        }
    }

    private void provideServerLibraries() {
        BundleMetadata serverBundleMetadata = this.minecraftProvider.getServerBundleMetadata();
        if (serverBundleMetadata == null) {
            return;
        }
        List<Library> libraries = MinecraftLibraryHelper.getServerLibraries(serverBundleMetadata);
        List<Library> processLibraries = this.processLibraries(libraries);
        processLibraries.forEach(this::applyServerLibrary);
    }

    private List<Library> processLibraries(List<Library> libraries) {
        LibraryContext libraryContext = new LibraryContext(this.minecraftProvider.getVersionInfo(), JavaVersion.current());
        return this.processorManager.processLibraries(libraries, libraryContext);
    }

    private void applyClientLibrary(Library library) {
        switch (library.target()) {
            case COMPILE: {
                this.addLibrary("minecraftClientLibraries", library);
                break;
            }
            case RUNTIME: {
                this.addLibrary("minecraftClientRuntimeLibraries", library);
                break;
            }
            case NATIVES: {
                this.addLibrary("minecraftNatives", library);
                break;
            }
            case LOCAL_MOD: {
                this.applyLocalModLibrary(library);
            }
        }
    }

    private void applyServerLibrary(Library library) {
        switch (library.target()) {
            case COMPILE: {
                this.addLibrary("minecraftServerLibraries", library);
                break;
            }
            case RUNTIME: {
                this.addLibrary("minecraftServerRuntimeLibraries", library);
                break;
            }
            case LOCAL_MOD: {
                this.applyLocalModLibrary(library);
                break;
            }
            default: {
                throw new IllegalStateException("Target not supported for server library: %s".formatted(library));
            }
        }
    }

    private void applyLocalModLibrary(Library library) {
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.project.getDependencies().create((Object)library.mavenNotation());
        dependency.setTransitive(false);
        this.project.getDependencies().add("modLocalRuntime", (Object)dependency);
    }

    private void addLibrary(String configuration, Library library) {
        this.addDependency(configuration, library.mavenNotation());
    }

    private void addDependency(String configuration, Object dependency) {
        Dependency created = this.project.getDependencies().add(configuration, dependency);
        if (created instanceof ModuleDependency) {
            ModuleDependency md = (ModuleDependency)created;
            md.setTransitive(false);
        }
    }
}

