/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.extension;

import javax.inject.Inject;
import net.fabricmc.loom.api.remapping.RemapperContext;
import net.fabricmc.loom.api.remapping.RemapperExtension;
import net.fabricmc.loom.api.remapping.RemapperParameters;
import net.fabricmc.loom.api.remapping.TinyRemapperExtension;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrClass;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;

public abstract class RemapperExtensionHolder {
    private final RemapperParameters remapperParameters;

    @Inject
    public RemapperExtensionHolder(RemapperParameters remapperParameters) {
        this.remapperParameters = remapperParameters;
    }

    @Input
    public abstract Property<String> getRemapperExtensionClassName();

    @Nested
    @Optional
    public RemapperParameters getRemapperParameters() {
        return this.remapperParameters;
    }

    public void apply(TinyRemapper.Builder tinyRemapperBuilder, String sourceNamespace, String targetNamespace, ObjectFactory objectFactory) {
        RemapperExtension<?> remapperExtension = this.newInstance(objectFactory);
        tinyRemapperBuilder.extraPostApplyVisitor((TinyRemapper.ApplyVisitorProvider)new RemapperExtensionImpl(remapperExtension, sourceNamespace, targetNamespace));
        if (remapperExtension instanceof TinyRemapperExtension) {
            TinyRemapperExtension tinyRemapperExtension = (TinyRemapperExtension)((Object)remapperExtension);
            TinyRemapper.AnalyzeVisitorProvider analyzeVisitorProvider = tinyRemapperExtension.getAnalyzeVisitorProvider();
            TinyRemapper.ApplyVisitorProvider preApplyVisitorProvider = tinyRemapperExtension.getPreApplyVisitor();
            TinyRemapper.ApplyVisitorProvider postApplyVisitorProvider = tinyRemapperExtension.getPostApplyVisitor();
            if (analyzeVisitorProvider != null) {
                tinyRemapperBuilder.extraAnalyzeVisitor(analyzeVisitorProvider);
            }
            if (preApplyVisitorProvider != null) {
                tinyRemapperBuilder.extraPreApplyVisitor(preApplyVisitorProvider);
            }
            if (postApplyVisitorProvider != null) {
                tinyRemapperBuilder.extraPostApplyVisitor(postApplyVisitorProvider);
            }
        }
    }

    private RemapperExtension<?> newInstance(ObjectFactory objectFactory) {
        try {
            Class<RemapperExtension> remapperExtensionClass = Class.forName((String)this.getRemapperExtensionClassName().get()).asSubclass(RemapperExtension.class);
            if (this.remapperParameters == RemapperParameters.None.INSTANCE) {
                return (RemapperExtension)objectFactory.newInstance(remapperExtensionClass, new Object[0]);
            }
            return (RemapperExtension)objectFactory.newInstance(remapperExtensionClass, new Object[]{this.remapperParameters});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create remapper extension", e);
        }
    }

    private static final class RemapperExtensionImpl
    implements TinyRemapper.ApplyVisitorProvider {
        private final RemapperExtension<?> remapperExtension;
        private final String sourceNamespace;
        private final String targetNamespace;
        @Nullable
        private RemapperContext context;

        private RemapperExtensionImpl(RemapperExtension<?> remapperExtension, String sourceNamespace, String targetNamespace) {
            this.remapperExtension = remapperExtension;
            this.sourceNamespace = sourceNamespace;
            this.targetNamespace = targetNamespace;
        }

        public ClassVisitor insertApplyVisitor(TrClass cls, ClassVisitor next) {
            if (this.context == null) {
                this.context = new RemapperContextImpl((Remapper)cls.getEnvironment().getRemapper(), this.sourceNamespace, this.targetNamespace);
            }
            return this.remapperExtension.insertVisitor(cls.getName(), this.context, next);
        }
    }

    private record RemapperContextImpl(Remapper remapper, String sourceNamespace, String targetNamespace) implements RemapperContext
    {
    }
}

