/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.assets.AssetIndex;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.MirrorUtil;
import net.fabricmc.loom.util.download.DownloadExecutor;
import net.fabricmc.loom.util.download.GradleDownloadProgressListener;
import net.fabricmc.loom.util.gradle.ProgressGroup;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class DownloadAssetsTask
extends AbstractLoomTask {
    @Input
    public abstract Property<String> getAssetsHash();

    @Input
    public abstract Property<Integer> getDownloadThreads();

    @Input
    public abstract Property<String> getMinecraftVersion();

    @OutputDirectory
    public abstract RegularFileProperty getAssetsDirectory();

    @OutputDirectory
    public abstract RegularFileProperty getLegacyResourcesDirectory();

    @Inject
    public DownloadAssetsTask() {
        MinecraftVersionMeta versionInfo = this.getExtension().getMinecraftProvider().getVersionInfo();
        File assetsDir = new File(this.getExtension().getFiles().getUserCache(), "assets");
        this.getAssetsDirectory().set(assetsDir);
        this.getAssetsHash().set((Object)versionInfo.assetIndex().sha1());
        this.getDownloadThreads().convention((Object)Math.min(Runtime.getRuntime().availableProcessors(), 10));
        this.getMinecraftVersion().set((Object)versionInfo.id());
        this.getMinecraftVersion().finalizeValue();
        if (versionInfo.assets().equals("legacy")) {
            this.getLegacyResourcesDirectory().set(new File(assetsDir, "/legacy/" + versionInfo.id()));
        } else {
            RunConfigSettings client = Objects.requireNonNull((RunConfigSettings)this.getExtension().getRunConfigs().findByName("client"), "Could not find client run config");
            this.getLegacyResourcesDirectory().set(new File(this.getProject().getProjectDir(), client.getRunDir() + "/resources"));
        }
        this.getAssetsHash().finalizeValue();
        this.getAssetsDirectory().finalizeValueOnRead();
        this.getLegacyResourcesDirectory().finalizeValueOnRead();
    }

    @TaskAction
    public void downloadAssets() throws IOException {
        AssetIndex assetIndex = this.getAssetIndex();
        try (ProgressGroup progressGroup = new ProgressGroup(this.getProject(), "Download Assets");
             DownloadExecutor executor = new DownloadExecutor((Integer)this.getDownloadThreads().get());){
            for (AssetIndex.Object object : assetIndex.getObjects()) {
                String sha1 = object.hash();
                String url = MirrorUtil.getResourcesBase((ExtensionAware)this.getProject()) + sha1.substring(0, 2) + "/" + sha1;
                this.getExtension().download(url).sha1(sha1).progress(new GradleDownloadProgressListener(object.name(), progressGroup::createProgressLogger)).downloadPathAsync(this.getAssetsPath(object, assetIndex), executor);
            }
        }
    }

    private MinecraftVersionMeta.AssetIndex getAssetIndexMeta() {
        MinecraftVersionMeta versionInfo = this.getExtension().getMinecraftProvider().getVersionInfo();
        return versionInfo.assetIndex();
    }

    private AssetIndex getAssetIndex() throws IOException {
        LoomGradleExtension extension = this.getExtension();
        MinecraftProvider minecraftProvider = extension.getMinecraftProvider();
        MinecraftVersionMeta.AssetIndex assetIndex = this.getAssetIndexMeta();
        File indexFile = new File(((RegularFile)this.getAssetsDirectory().get()).getAsFile(), "indexes" + File.separator + assetIndex.fabricId(minecraftProvider.minecraftVersion()) + ".json");
        String json = extension.download(assetIndex.url()).sha1(assetIndex.sha1()).downloadString(indexFile.toPath());
        return (AssetIndex)LoomGradlePlugin.GSON.fromJson(json, AssetIndex.class);
    }

    private Path getAssetsPath(AssetIndex.Object object, AssetIndex index) {
        if (index.mapToResources() || index.virtual()) {
            return new File(((RegularFile)this.getLegacyResourcesDirectory().get()).getAsFile(), object.path()).toPath();
        }
        String filename = "objects" + File.separator + object.hash().substring(0, 2) + File.separator + object.hash();
        return new File(((RegularFile)this.getAssetsDirectory().get()).getAsFile(), filename).toPath();
    }
}

