/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerRemapper;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.fabricmc.accesswidener.AccessWidenerWriter;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.nesting.IncludedJarFactory;
import net.fabricmc.loom.build.nesting.JarNester;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerFile;
import net.fabricmc.loom.configuration.mods.ArtifactMetadata;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.task.PrepareJarRemapTask;
import net.fabricmc.loom.task.service.TinyRemapperService;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.loom.util.SidedClassVisitor;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import net.fabricmc.loom.util.service.BuildSharedServiceManager;
import net.fabricmc.loom.util.service.UnsafeWorkQueueHelper;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemapJarTask
extends AbstractRemapJarTask {
    private final Provider<BuildSharedServiceManager> serviceManagerProvider = BuildSharedServiceManager.createForTask((Task)this, this.getBuildEventsListenerRegistry());

    @InputFiles
    public abstract ConfigurableFileCollection getNestedJars();

    @Input
    public abstract Property<Boolean> getAddNestedDependencies();

    @Input
    @ApiStatus.Internal
    public abstract Property<Boolean> getUseMixinAP();

    @Inject
    public RemapJarTask() {
        ConfigurationContainer configurations = this.getProject().getConfigurations();
        this.getClasspath().from(new Object[]{configurations.getByName("compileClasspath")});
        this.getAddNestedDependencies().convention((Object)true).finalizeValueOnRead();
        Configuration includeConfiguration = configurations.getByName("include");
        this.getNestedJars().from(new Object[]{new IncludedJarFactory(this.getProject()).getNestedJars(includeConfiguration)});
        this.getUseMixinAP().set(LoomGradleExtension.get(this.getProject()).getMixin().getUseLegacyMixinAp());
        if (this.getLoomExtension().multiProjectOptimisation()) {
            this.setupPreparationTask();
        }
        this.setReproducibleFileOrder(true);
        this.setPreserveFileTimestamps(false);
        this.getJarType().set((Object)"classes");
    }

    private void setupPreparationTask() {
        PrepareJarRemapTask prepareJarTask = (PrepareJarRemapTask)this.getProject().getTasks().create("prepare" + this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1), PrepareJarRemapTask.class, new Object[]{this});
        this.dependsOn(new Object[]{prepareJarTask});
        this.mustRunAfter(new Object[]{prepareJarTask});
        this.getProject().getGradle().allprojects(project -> project.getTasks().configureEach(task -> {
            if (task instanceof PrepareJarRemapTask) {
                PrepareJarRemapTask otherTask = (PrepareJarRemapTask)((Object)((Object)task));
                this.mustRunAfter(new Object[]{otherTask});
            }
        }));
    }

    @TaskAction
    public void run() {
        this.submitWork(RemapAction.class, params -> {
            if (((Boolean)this.getAddNestedDependencies().get()).booleanValue()) {
                params.getNestedJars().from(new Object[]{this.getNestedJars()});
            }
            if (!params.namespacesMatch()) {
                params.getTinyRemapperBuildServiceUuid().set((Object)UnsafeWorkQueueHelper.create(this.getTinyRemapperService()));
                params.getRemapClasspath().from(new Object[]{this.getClasspath()});
                params.getMultiProjectOptimisation().set((Object)this.getLoomExtension().multiProjectOptimisation());
                boolean mixinAp = (Boolean)this.getUseMixinAP().get();
                params.getUseMixinExtension().set((Object)(!mixinAp ? 1 : 0));
                if (mixinAp) {
                    this.setupLegacyMixinRefmapRemapping((RemapParams)params);
                }
                ArtifactMetadata.MixinRemapType refmapRemapType = mixinAp ? ArtifactMetadata.MixinRemapType.MIXIN : ArtifactMetadata.MixinRemapType.STATIC;
                params.getManifestAttributes().put((Object)"Fabric-Loom-Mixin-Remap-Type", (Object)refmapRemapType.manifestValue());
            }
        });
    }

    private void setupLegacyMixinRefmapRemapping(RemapParams params) {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        MixinExtension mixinExtension = extension.getMixin();
        FabricModJson fabricModJson = FabricModJsonFactory.createFromZipNullable(((File)this.getInputFile().getAsFile().get()).toPath());
        if (fabricModJson == null) {
            return;
        }
        List<String> allMixinConfigs = fabricModJson.getMixinConfigurations();
        for (SourceSet sourceSet : mixinExtension.getMixinSourceSets()) {
            MixinExtension.MixinInformationContainer container = Objects.requireNonNull(MixinExtension.getMixinInformationContainer(sourceSet));
            List<String> rootPaths = RemapJarTask.getRootPaths(sourceSet.getResources().getSrcDirs());
            String refmapName = (String)container.refmapNameProvider().get();
            List<String> mixinConfigs = container.sourceSet().getResources().matching((PatternFilterable)container.mixinConfigPattern()).getFiles().stream().map(RemapJarTask.relativePath(rootPaths)).filter(allMixinConfigs::contains).toList();
            params.getMixinData().add((Object)new RemapParams.RefmapData(mixinConfigs, refmapName));
        }
    }

    @Override
    protected List<String> getClientOnlyEntries(SourceSet clientSourceSet) {
        ConfigurableFileCollection output = this.getProject().getObjects().fileCollection();
        output.from(new Object[]{clientSourceSet.getOutput().getClassesDirs()});
        output.from(new Object[]{clientSourceSet.getOutput().getResourcesDir()});
        ArrayList<String> rootPaths = new ArrayList<String>();
        rootPaths.addAll(RemapJarTask.getRootPaths(clientSourceSet.getOutput().getClassesDirs().getFiles()));
        rootPaths.addAll(RemapJarTask.getRootPaths(Set.of(Objects.requireNonNull(clientSourceSet.getOutput().getResourcesDir()))));
        return output.getAsFileTree().getFiles().stream().map(RemapJarTask.relativePath(rootPaths)).toList();
    }

    @Internal
    public TinyRemapperService getTinyRemapperService() {
        return TinyRemapperService.getOrCreate(((BuildSharedServiceManager)this.serviceManagerProvider.get()).get(), this);
    }

    public static abstract class RemapAction
    extends AbstractRemapJarTask.AbstractRemapAction<RemapParams> {
        private static final Logger LOGGER = LoggerFactory.getLogger(RemapAction.class);
        @Nullable
        private final TinyRemapperService tinyRemapperService = ((RemapParams)this.getParameters()).getTinyRemapperBuildServiceUuid().isPresent() ? UnsafeWorkQueueHelper.get(((RemapParams)this.getParameters()).getTinyRemapperBuildServiceUuid(), TinyRemapperService.class) : null;
        @Nullable
        private TinyRemapper tinyRemapper;

        public void execute() {
            try {
                LOGGER.info("Remapping {} to {}", (Object)this.inputFile, (Object)this.outputFile);
                if (!((Boolean)((RemapParams)this.getParameters()).getMultiProjectOptimisation().getOrElse((Object)false)).booleanValue()) {
                    this.prepare();
                }
                if (this.tinyRemapperService != null) {
                    this.tinyRemapper = this.tinyRemapperService.getTinyRemapperForRemapping();
                    this.remap();
                } else {
                    Files.copy(this.inputFile, this.outputFile, StandardCopyOption.REPLACE_EXISTING);
                }
                if (((RemapParams)this.getParameters()).getClientOnlyEntries().isPresent()) {
                    this.markClientOnlyClasses();
                }
                this.remapAccessWidener();
                this.addRefmaps();
                this.addNestedJars();
                this.modifyJarManifest();
                this.rewriteJar();
                if (this.tinyRemapperService != null && !((Boolean)((RemapParams)this.getParameters()).getMultiProjectOptimisation().get()).booleanValue()) {
                    this.tinyRemapperService.close();
                }
                LOGGER.debug("Finished remapping {}", (Object)this.inputFile);
            }
            catch (Exception e) {
                try {
                    Files.deleteIfExists(this.outputFile);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to delete output file", (Throwable)ex);
                }
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to remap", e);
            }
        }

        private void prepare() {
            Path inputFile = ((File)((RemapParams)this.getParameters()).getInputFile().getAsFile().get()).toPath();
            if (this.tinyRemapperService != null) {
                PrepareJarRemapTask.prepare(this.tinyRemapperService, inputFile);
            }
        }

        private void remap() throws IOException {
            Objects.requireNonNull(this.tinyRemapperService, "tinyRemapperService");
            Objects.requireNonNull(this.tinyRemapper, "tinyRemapper");
            try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(this.outputFile).build();){
                outputConsumer.addNonClassFiles(this.inputFile);
                this.tinyRemapper.apply((BiConsumer)outputConsumer, new InputTag[]{this.tinyRemapperService.getOrCreateTag(this.inputFile)});
            }
        }

        private void markClientOnlyClasses() throws IOException {
            Stream<Pair<String, ZipUtils.UnsafeUnaryOperator<byte[]>>> tranformers = ((List)((RemapParams)this.getParameters()).getClientOnlyEntries().get()).stream().map(s -> new Pair<String, ZipUtils.AsmClassOperator>((String)s, classVisitor -> SidedClassVisitor.CLIENT.insertApplyVisitor(null, classVisitor)));
            ZipUtils.transform(this.outputFile, tranformers);
        }

        private void remapAccessWidener() throws IOException {
            if (((RemapParams)this.getParameters()).namespacesMatch()) {
                return;
            }
            AccessWidenerFile accessWidenerFile = AccessWidenerFile.fromModJar(this.inputFile);
            if (accessWidenerFile == null) {
                return;
            }
            byte[] remapped = this.remapAccessWidener(accessWidenerFile.content());
            ZipUtils.replace(this.outputFile, accessWidenerFile.path(), remapped);
        }

        private byte[] remapAccessWidener(byte[] input) {
            Objects.requireNonNull(this.tinyRemapper, "tinyRemapper");
            int version = AccessWidenerReader.readVersion((byte[])input);
            AccessWidenerWriter writer = new AccessWidenerWriter(version);
            AccessWidenerRemapper remapper = new AccessWidenerRemapper((AccessWidenerVisitor)writer, (Remapper)this.tinyRemapper.getEnvironment().getRemapper(), (String)((RemapParams)this.getParameters()).getSourceNamespace().get(), (String)((RemapParams)this.getParameters()).getTargetNamespace().get());
            AccessWidenerReader reader = new AccessWidenerReader((AccessWidenerVisitor)remapper);
            reader.read(input);
            return writer.write();
        }

        private void addNestedJars() {
            ConfigurableFileCollection nestedJars = ((RemapParams)this.getParameters()).getNestedJars();
            if (nestedJars.isEmpty()) {
                LOGGER.info("No jars to nest");
                return;
            }
            JarNester.nestJars(nestedJars.getFiles(), this.outputFile.toFile(), LOGGER);
        }

        private void addRefmaps() throws IOException {
            if (((Boolean)((RemapParams)this.getParameters()).getUseMixinExtension().getOrElse((Object)false)).booleanValue()) {
                return;
            }
            for (RemapParams.RefmapData refmapData : (List)((RemapParams)this.getParameters()).getMixinData().get()) {
                if (!ZipUtils.contains(this.outputFile, refmapData.refmapName())) continue;
                int n = ZipUtils.transformJson(JsonObject.class, this.outputFile, refmapData.mixinConfigs().stream().collect(Collectors.toMap(s -> s, s -> json -> {
                    if (!json.has("refmap")) {
                        json.addProperty("refmap", refmapData.refmapName());
                    }
                    return json;
                })));
            }
        }
    }

    public static interface RemapParams
    extends AbstractRemapJarTask.AbstractRemapParams {
        public ConfigurableFileCollection getNestedJars();

        public ConfigurableFileCollection getRemapClasspath();

        public Property<Boolean> getUseMixinExtension();

        public Property<Boolean> getMultiProjectOptimisation();

        public ListProperty<RefmapData> getMixinData();

        public Property<String> getTinyRemapperBuildServiceUuid();

        public record RefmapData(List<String> mixinConfigs, String refmapName) implements Serializable
        {
        }
    }
}

