/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.lorenztiny.TinyMappingsReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.cadixdev.lorenz.MappingSet;

public final class LorenzMappingService
implements SharedService {
    private MappingSet mappings;

    public LorenzMappingService(MappingSet mappings) {
        this.mappings = mappings;
    }

    public static synchronized LorenzMappingService create(SharedServiceManager sharedServiceManager, MappingConfiguration mappingConfiguration, MappingsNamespace from, MappingsNamespace to) {
        return sharedServiceManager.getOrCreateService(mappingConfiguration.getBuildServiceName("LorenzMappingService", from.toString(), to.toString()), () -> {
            LorenzMappingService lorenzMappingService;
            MemoryMappingTree m = mappingConfiguration.getMappingsService(sharedServiceManager).getMappingTree();
            TinyMappingsReader reader = new TinyMappingsReader((MappingTree)m, from.toString(), to.toString());
            try {
                lorenzMappingService = new LorenzMappingService(reader.read());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read lorenz mappings", e);
                }
            }
            reader.close();
            return lorenzMappingService;
        });
    }

    @Override
    public void close() throws IOException {
        this.mappings = null;
    }

    public MappingSet mappings() {
        return Objects.requireNonNull(this.mappings);
    }
}

